/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.fafquery.querymethod;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetInstance;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetProcessor;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.EPPreparedQueryResult;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodAssignerSetter;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelect;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExec;
import com.espertech.esper.common.internal.epl.fafquery.querymethod.FAFQueryMethodSelectExecUtil;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.Collection;
import java.util.Set;

public class FAFQueryMethodSelectExecNoContextJoin
implements FAFQueryMethodSelectExec {
    public static final FAFQueryMethodSelectExec INSTANCE = new FAFQueryMethodSelectExecNoContextJoin();

    private FAFQueryMethodSelectExecNoContextJoin() {
    }

    @Override
    public EPPreparedQueryResult execute(FAFQueryMethodSelect select, ContextPartitionSelector[] contextPartitionSelectors, FAFQueryMethodAssignerSetter assignerSetter, ContextManagementService contextManagementService) {
        int numStreams = select.getProcessors().length;
        Collection[] snapshots = new Collection[numStreams];
        AgentInstanceContext agentInstanceContext = null;
        Viewable[] viewablePerStream = new Viewable[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            FireAndForgetProcessor processor = select.getProcessors()[i];
            FireAndForgetInstance processorInstance = processor.getProcessorInstanceNoContext();
            snapshots[i] = FAFQueryMethodSelectExecUtil.snapshot(select.getConsumerFilters()[i], processorInstance, select.getQueryGraph(), select.getAnnotations());
            agentInstanceContext = processorInstance.getAgentInstanceContext();
            viewablePerStream[i] = processorInstance.getTailViewInstance();
        }
        ResultSetProcessor resultSetProcessor = FAFQueryMethodSelectExecUtil.processorWithAssign(select.getResultSetProcessorFactoryProvider(), agentInstanceContext, assignerSetter, select.getTableAccesses(), select.getSubselects());
        JoinSetComposerDesc joinSetComposerDesc = select.getJoinSetComposerPrototype().create(viewablePerStream, true, agentInstanceContext, false);
        JoinSetComposer joinComposer = joinSetComposerDesc.getJoinSetComposer();
        EventBean[][] oldDataPerStream = new EventBean[numStreams][];
        EventBean[][] newDataPerStream = new EventBean[numStreams][];
        for (int i = 0; i < numStreams; ++i) {
            newDataPerStream[i] = snapshots[i].toArray(new EventBean[snapshots[i].size()]);
        }
        UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>> result = joinComposer.join(newDataPerStream, oldDataPerStream, agentInstanceContext);
        if (joinSetComposerDesc.getPostJoinFilterEvaluator() != null) {
            JoinSetComposerUtil.filter(joinSetComposerDesc.getPostJoinFilterEvaluator(), result.getFirst(), true, agentInstanceContext);
        }
        UniformPair<EventBean[]> results = resultSetProcessor.processJoinResult(result.getFirst(), null, true);
        EventBean[] distinct = EventBeanUtility.getDistinctByProp(results.getFirst(), select.getDistinctKeyGetter());
        return new EPPreparedQueryResult(resultSetProcessor.getResultEventType(), distinct);
    }

    @Override
    public void releaseTableLocks(FireAndForgetProcessor[] processors) {
        FAFQueryMethodSelectExecUtil.releaseTableLocks(processors);
    }
}

