/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.common;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.IterablesArrayIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewable;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewableFactoryBase;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCache;
import com.espertech.esper.common.internal.epl.historical.execstrategy.PollExecStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.UnindexedEventTableList;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.Iterator;
import java.util.List;

public abstract class HistoricalEventViewableBase
implements Viewable,
HistoricalEventViewable {
    protected final HistoricalEventViewableFactoryBase factory;
    protected final PollExecStrategy pollExecStrategy;
    protected final ExprEvaluatorContext exprEvaluatorContext;
    protected HistoricalDataCache dataCache;
    protected View child;
    protected static final EventBean[][] NULL_ROWS = new EventBean[1][];
    private static final PollResultIndexingStrategy ITERATOR_INDEXING_STRATEGY;

    public HistoricalEventViewableBase(HistoricalEventViewableFactoryBase factory, PollExecStrategy pollExecStrategy, ExprEvaluatorContext exprEvaluatorContext) {
        this.factory = factory;
        this.pollExecStrategy = pollExecStrategy;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        this.pollExecStrategy.destroy();
        this.dataCache.destroy();
    }

    @Override
    public void setChild(View view) {
        this.child = view;
    }

    @Override
    public View getChild() {
        return this.child;
    }

    @Override
    public EventTable[][] poll(EventBean[][] lookupEventsPerStream, PollResultIndexingStrategy indexingStrategy, ExprEvaluatorContext exprEvaluatorContext) {
        HistoricalDataCache localDataCache = this.factory.getDataCacheThreadLocal().get();
        boolean strategyStarted = false;
        EventTable[][] resultPerInputRow = new EventTable[lookupEventsPerStream.length][];
        for (int row = 0; row < lookupEventsPerStream.length; ++row) {
            EventTable[] multi;
            EventBean[] eventsPerStream = lookupEventsPerStream[row];
            Object lookupValue = this.factory.evaluator.evaluate(eventsPerStream, true, exprEvaluatorContext);
            EventTable[] result = null;
            Object cacheMultiKey = null;
            if (localDataCache != null || this.dataCache.isActive()) {
                cacheMultiKey = this.factory.lookupValueToMultiKey.transform(lookupValue);
            }
            if (localDataCache != null) {
                EventTable[] tables;
                result = tables = localDataCache.getCached(cacheMultiKey);
            }
            if (result == null && (multi = this.dataCache.getCached(cacheMultiKey)) != null) {
                result = multi;
                if (localDataCache != null) {
                    localDataCache.put(cacheMultiKey, multi);
                }
            }
            if (result != null) {
                resultPerInputRow[row] = result;
                continue;
            }
            try {
                if (!strategyStarted) {
                    this.pollExecStrategy.start();
                    strategyStarted = true;
                }
                List<EventBean> pollResult = this.pollExecStrategy.poll(lookupValue, this.exprEvaluatorContext);
                EventTable[] indexTable = indexingStrategy.index(pollResult, this.dataCache.isActive(), this.exprEvaluatorContext);
                resultPerInputRow[row] = indexTable;
                this.dataCache.put(cacheMultiKey, indexTable);
                if (localDataCache == null) continue;
                localDataCache.put(cacheMultiKey, indexTable);
                continue;
            }
            catch (EPException ex) {
                if (strategyStarted) {
                    this.pollExecStrategy.done();
                }
                throw ex;
            }
        }
        if (strategyStarted) {
            this.pollExecStrategy.done();
        }
        return resultPerInputRow;
    }

    @Override
    public EventType getEventType() {
        return this.factory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        EventTable[][] tablesPerRow = this.poll(NULL_ROWS, ITERATOR_INDEXING_STRATEGY, this.exprEvaluatorContext);
        return new IterablesArrayIterator(tablesPerRow);
    }

    @Override
    public ThreadLocal<HistoricalDataCache> getDataCacheThreadLocal() {
        return this.factory.getDataCacheThreadLocal();
    }

    @Override
    public boolean hasRequiredStreams() {
        return this.factory.isHasRequiredStreams();
    }

    @Override
    public HistoricalDataCache getOptionalDataCache() {
        return this.dataCache;
    }

    static {
        HistoricalEventViewableBase.NULL_ROWS[0] = new EventBean[1];
        ITERATOR_INDEXING_STRATEGY = new PollResultIndexingStrategy(){

            @Override
            public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, ExprEvaluatorContext exprEvaluatorContext) {
                return new EventTable[]{new UnindexedEventTableList(pollResult, -1)};
            }
        };
    }
}

