/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.database.connection;

import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCache;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonDBRef;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigException;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigServiceCompileTime;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigServiceRuntime;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConnectionFactory;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseDMConnFactory;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseDSConnFactory;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseDSFactoryConnFactory;
import com.espertech.esper.common.internal.epl.historical.database.core.ColumnSettings;
import com.espertech.esper.common.internal.epl.historical.database.core.ConnectionCache;
import com.espertech.esper.common.internal.epl.historical.database.core.ConnectionCacheImpl;
import com.espertech.esper.common.internal.epl.historical.database.core.ConnectionCacheNoCacheImpl;
import com.espertech.esper.common.internal.epl.historical.datacache.HistoricalDataCache;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import java.util.HashMap;
import java.util.Map;

public class DatabaseConfigServiceImpl
implements DatabaseConfigServiceCompileTime,
DatabaseConfigServiceRuntime {
    private final Map<String, ConfigurationCommonDBRef> mapDatabaseRef;
    private final Map<String, DatabaseConnectionFactory> connectionFactories;
    private final ClasspathImportService classpathImportService;

    public DatabaseConfigServiceImpl(Map<String, ConfigurationCommonDBRef> mapDatabaseRef, ClasspathImportService classpathImportService) {
        this.mapDatabaseRef = mapDatabaseRef;
        this.connectionFactories = new HashMap<String, DatabaseConnectionFactory>();
        this.classpathImportService = classpathImportService;
    }

    @Override
    public DatabaseConnectionFactory getConnectionFactory(String databaseName) throws DatabaseConfigException {
        DatabaseConnectionFactory factory = this.connectionFactories.get(databaseName);
        if (factory != null) {
            return factory;
        }
        ConfigurationCommonDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + "'");
        }
        ConfigurationCommonDBRef.ConnectionSettings settings = config.getConnectionSettings();
        if (config.getConnectionFactoryDesc() instanceof ConfigurationCommonDBRef.DriverManagerConnection) {
            ConfigurationCommonDBRef.DriverManagerConnection dmConfig = (ConfigurationCommonDBRef.DriverManagerConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDMConnFactory(dmConfig, settings, this.classpathImportService);
        } else if (config.getConnectionFactoryDesc() instanceof ConfigurationCommonDBRef.DataSourceConnection) {
            ConfigurationCommonDBRef.DataSourceConnection dsConfig = (ConfigurationCommonDBRef.DataSourceConnection)config.getConnectionFactoryDesc();
            factory = new DatabaseDSConnFactory(dsConfig, settings);
        } else if (config.getConnectionFactoryDesc() instanceof ConfigurationCommonDBRef.DataSourceFactory) {
            ConfigurationCommonDBRef.DataSourceFactory dsConfig = (ConfigurationCommonDBRef.DataSourceFactory)config.getConnectionFactoryDesc();
            factory = new DatabaseDSFactoryConnFactory(dsConfig, settings, this.classpathImportService);
        } else {
            if (config.getConnectionFactoryDesc() == null) {
                throw new DatabaseConfigException("No connection factory setting provided in configuration");
            }
            throw new DatabaseConfigException("Unknown connection factory setting provided in configuration");
        }
        this.connectionFactories.put(databaseName, factory);
        return factory;
    }

    @Override
    public ColumnSettings getQuerySetting(String databaseName) throws DatabaseConfigException {
        ConfigurationCommonDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + "'");
        }
        return new ColumnSettings(config.getMetadataRetrievalEnum(), config.getColumnChangeCase(), config.getSqlTypesMapping());
    }

    @Override
    public HistoricalDataCache getDataCache(String databaseName, AgentInstanceContext agentInstanceContext, int streamNumber, int scheduleCallbackId) throws DatabaseConfigException {
        ConfigurationCommonDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + "'");
        }
        ConfigurationCommonCache dataCacheDesc = config.getDataCacheDesc();
        return agentInstanceContext.getHistoricalDataCacheFactory().getDataCache(dataCacheDesc, agentInstanceContext, streamNumber, scheduleCallbackId);
    }

    @Override
    public ConnectionCache getConnectionCache(String databaseName, String preparedStatementText) throws DatabaseConfigException {
        ConfigurationCommonDBRef config = this.mapDatabaseRef.get(databaseName);
        if (config == null) {
            throw new DatabaseConfigException("Cannot locate configuration information for database '" + databaseName + "'");
        }
        DatabaseConnectionFactory connectionFactory = this.getConnectionFactory(databaseName);
        boolean retain = config.getConnectionLifecycleEnum().equals((Object)ConfigurationCommonDBRef.ConnectionLifecycleEnum.RETAIN);
        if (retain) {
            return new ConnectionCacheImpl(connectionFactory, preparedStatementText);
        }
        return new ConnectionCacheNoCacheImpl(connectionFactory, preparedStatementText);
    }
}

