/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.database.connection;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonDBRef;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConfigException;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseConnectionFactory;
import com.espertech.esper.common.internal.epl.historical.database.connection.DatabaseDMConnFactory;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class DatabaseDSFactoryConnFactory
implements DatabaseConnectionFactory {
    private final ConfigurationCommonDBRef.ConnectionSettings connectionSettings;
    private DataSource dataSource;

    public DatabaseDSFactoryConnFactory(ConfigurationCommonDBRef.DataSourceFactory dsConfig, ConfigurationCommonDBRef.ConnectionSettings connectionSettings, ClasspathImportService classpathImportService) throws DatabaseConfigException {
        Object result;
        Method method;
        Object obj;
        Class clazz;
        this.connectionSettings = connectionSettings;
        try {
            clazz = classpathImportService.getClassForNameProvider().classForName(dsConfig.getFactoryClassname());
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseConfigException("Class '" + dsConfig.getFactoryClassname() + "' cannot be loaded", e);
        }
        try {
            obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new ConfigurationException("Class '" + clazz + "' cannot be instantiated", e);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ConfigurationException("Illegal access instantiating class '" + clazz + "'", e);
        }
        try {
            method = clazz.getMethod("createDataSource", Properties.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Class '" + clazz + "' does not provide a static method by name createDataSource accepting a single Properties object as parameter", e);
        }
        if (method == null) {
            throw new ConfigurationException("Class '" + clazz + "' does not provide a static method by name createDataSource accepting a single Properties object as parameter");
        }
        if (!JavaClassHelper.isImplementsInterface(method.getReturnType(), DataSource.class)) {
            throw new ConfigurationException("On class '" + clazz + "' the static method by name createDataSource does not return a DataSource");
        }
        try {
            result = method.invoke(obj, dsConfig.getProperties());
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Class '" + clazz + "' failed in method createDataSource :" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Class '" + clazz + "' failed in method createDataSource :" + e.getMessage(), e);
        }
        if (result == null) {
            throw new ConfigurationException("Method createDataSource returned a null value for DataSource");
        }
        this.dataSource = (DataSource)result;
    }

    @Override
    public Connection getConnection() throws DatabaseConfigException {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            String detail = "SQLException: " + ex.getMessage() + " SQLState: " + ex.getSQLState() + " VendorError: " + ex.getErrorCode();
            throw new DatabaseConfigException("Error obtaining database connection using datasource with detail " + detail, ex);
        }
        DatabaseDMConnFactory.setConnectionOptions(connection, this.connectionSettings);
        return connection;
    }
}

