/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.indexingstrategy;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.UnindexedEventTableList;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableFactory;
import java.util.List;

public class PollResultIndexingStrategyInKeywordMulti
implements PollResultIndexingStrategy {
    public static final EPTypeClass EPTYPE = new EPTypeClass(PollResultIndexingStrategyInKeywordMulti.class);
    private int streamNum;
    private String[] propertyNames;
    private EventPropertyValueGetter[] valueGetters;
    private PropertyHashedEventTableFactory[] factories;

    @Override
    public EventTable[] index(List<EventBean> pollResult, boolean isActiveCache, ExprEvaluatorContext exprEvaluatorContext) {
        if (!isActiveCache) {
            return new EventTable[]{new UnindexedEventTableList(pollResult, this.streamNum)};
        }
        EventTable[] tables = new EventTable[this.valueGetters.length];
        for (int i = 0; i < this.valueGetters.length; ++i) {
            tables[i] = this.factories[i].makeEventTables(exprEvaluatorContext, null)[0];
            tables[i].add(pollResult.toArray(new EventBean[pollResult.size()]), exprEvaluatorContext);
        }
        return tables;
    }

    public void setStreamNum(int streamNum) {
        this.streamNum = streamNum;
    }

    public void setPropertyNames(String[] propertyNames) {
        this.propertyNames = propertyNames;
    }

    public void setValueGetters(EventPropertyValueGetter[] valueGetters) {
        this.valueGetters = valueGetters;
    }

    public void init() {
        this.factories = new PropertyHashedEventTableFactory[this.valueGetters.length];
        for (int i = 0; i < this.propertyNames.length; ++i) {
            this.factories[i] = new PropertyHashedEventTableFactory(this.streamNum, new String[]{this.propertyNames[i]}, false, null, this.valueGetters[i], null);
        }
    }
}

