/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.method.poll;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategy;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategyFactory;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategyStaticMethodInvokeType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodTargetStrategyStaticMethod
implements MethodTargetStrategy,
MethodTargetStrategyFactory,
StatementReadyCallback {
    public static final EPTypeClass EPTYPE = new EPTypeClass(MethodTargetStrategyStaticMethod.class);
    private Class clazz;
    private String methodName;
    private Class[] methodParameters;
    private Method method;
    private MethodTargetStrategyStaticMethodInvokeType invokeType;

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        this.method = MethodTargetStrategyStaticMethod.resolveMethod(this.clazz, this.methodName, this.methodParameters);
        this.invokeType = MethodTargetStrategyStaticMethodInvokeType.getInvokeType(this.method);
    }

    @Override
    public MethodTargetStrategy make(AgentInstanceContext agentInstanceContext) {
        return this;
    }

    @Override
    public Object invoke(Object lookupValues, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            switch (this.invokeType) {
                case NOPARAM: {
                    return this.method.invoke(null, null);
                }
                case SINGLE: {
                    return this.method.invoke(null, lookupValues);
                }
                case MULTIKEY: {
                    return this.method.invoke(null, (Object[])lookupValues);
                }
            }
            throw new IllegalStateException("Unrecognized value for " + this.invokeType);
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Method '" + this.method.getName() + "' of class '" + this.method.getDeclaringClass().getName() + "' reported an exception: " + ex.getTargetException(), ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new EPException("Method '" + this.method.getName() + "' of class '" + this.method.getDeclaringClass().getName() + "' reported an exception: " + ex, ex);
        }
    }

    public void setInvokeType(MethodTargetStrategyStaticMethodInvokeType invokeType) {
        this.invokeType = invokeType;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setMethodParameters(Class[] methodParameters) {
        this.methodParameters = methodParameters;
    }

    @Override
    public String getPlan() {
        return "method '" + this.methodName + "' of class '" + this.clazz.getName() + "'";
    }

    protected static Method resolveMethod(Class clazz, String methodName, Class[] methodParameters) {
        Method method;
        try {
            method = clazz.getMethod(methodName, methodParameters);
        }
        catch (NoSuchMethodException ex) {
            throw new EPException("Failed to find method '" + methodName + "' of class '" + clazz.getName() + "' with parameters " + ClassHelperPrint.getParameterAsString(methodParameters));
        }
        return method;
    }
}

