/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.historical.method.poll;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategy;
import com.espertech.esper.common.internal.epl.historical.method.poll.MethodTargetStrategyVariableFactory;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import java.lang.reflect.InvocationTargetException;

public class MethodTargetStrategyVariable
implements MethodTargetStrategy {
    private final MethodTargetStrategyVariableFactory factory;
    private final VariableReader reader;

    public MethodTargetStrategyVariable(MethodTargetStrategyVariableFactory factory, VariableReader reader) {
        this.factory = factory;
        this.reader = reader;
    }

    @Override
    public Object invoke(Object lookupValues, ExprEvaluatorContext exprEvaluatorContext) {
        Object target = this.reader.getValue();
        if (target == null) {
            return null;
        }
        if (target instanceof EventBean) {
            target = ((EventBean)target).getUnderlying();
        }
        try {
            switch (this.factory.invokeType) {
                case NOPARAM: {
                    return this.factory.method.invoke(target, null);
                }
                case SINGLE: {
                    return this.factory.method.invoke(target, lookupValues);
                }
                case MULTIKEY: {
                    return this.factory.method.invoke(target, (Object[])lookupValues);
                }
            }
            throw new IllegalStateException("Unrecognized value for " + this.factory.invokeType);
        }
        catch (InvocationTargetException ex) {
            throw new EPException("Method '" + this.factory.method.getName() + "' of class '" + this.factory.method.getDeclaringClass().getName() + "' reported an exception: " + ex.getTargetException(), ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new EPException("Method '" + this.factory.method.getName() + "' of class '" + this.factory.method.getDeclaringClass().getName() + "' reported an exception: " + ex, ex);
        }
    }

    @Override
    public String getPlan() {
        return "Variable '" + this.reader.getMetaData().getVariableName() + "'";
    }
}

