/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.index.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTable;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableFactory;
import com.espertech.esper.common.internal.epl.index.hash.PropertyHashedEventTableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PropertyHashedEventTableUnadorned
extends PropertyHashedEventTable {
    protected final Map<Object, Set<EventBean>> propertyIndex = new HashMap<Object, Set<EventBean>>();

    public PropertyHashedEventTableUnadorned(PropertyHashedEventTableFactory factory) {
        super(factory);
    }

    @Override
    public Set<EventBean> lookup(Object key) {
        return this.propertyIndex.get(key);
    }

    @Override
    public Set<EventBean> lookupFAF(Object key) {
        Set<EventBean> result = this.propertyIndex.get(key);
        return result == null ? null : new LinkedHashSet<EventBean>(result);
    }

    @Override
    public void add(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        Set events = this.propertyIndex.computeIfAbsent(key, k -> new LinkedHashSet());
        events.add(theEvent);
    }

    @Override
    public void remove(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        Object key = this.getKey(theEvent);
        Set<EventBean> events = this.propertyIndex.get(key);
        if (events == null) {
            return;
        }
        if (!events.remove(theEvent)) {
            return;
        }
        if (events.isEmpty()) {
            this.propertyIndex.remove(key);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.propertyIndex.isEmpty();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new PropertyHashedEventTableIterator<Object>(this.propertyIndex);
    }

    @Override
    public void clear() {
        this.propertyIndex.clear();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public Integer getNumberOfEvents() {
        return null;
    }

    @Override
    public int getNumKeys() {
        return this.propertyIndex.size();
    }

    @Override
    public Object getIndex() {
        return this.propertyIndex;
    }

    @Override
    public Class<?> getProviderClass() {
        return PropertyHashedEventTable.class;
    }
}

