/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.assemble;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.join.assemble.ResultAssembler;
import com.espertech.esper.common.internal.epl.join.rep.Node;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class BaseAssemblyNode
implements ResultAssembler {
    protected ResultAssembler parentNode;
    protected final List<BaseAssemblyNode> childNodes;
    protected final int streamNum;
    protected final int numStreams;

    protected BaseAssemblyNode(int streamNum, int numStreams) {
        this.streamNum = streamNum;
        this.numStreams = numStreams;
        this.childNodes = new ArrayList<BaseAssemblyNode>(4);
    }

    public abstract void init(List<Node>[] var1);

    public abstract void process(List<Node>[] var1, Collection<EventBean[]> var2, EventBean var3);

    public abstract void print(IndentWriter var1);

    public void setParentAssembler(ResultAssembler resultAssembler) {
        this.parentNode = resultAssembler;
    }

    public void addChild(BaseAssemblyNode childNode) {
        childNode.parentNode = this;
        this.childNodes.add(childNode);
    }

    protected int getStreamNum() {
        return this.streamNum;
    }

    protected List<BaseAssemblyNode> getChildNodes() {
        return this.childNodes;
    }

    protected int[] getSubstreams() {
        LinkedList<Integer> substreams = new LinkedList<Integer>();
        this.recusiveAddSubstreams(substreams);
        int[] substreamArr = new int[substreams.size()];
        int count = 0;
        for (Integer stream : substreams) {
            substreamArr[count++] = stream;
        }
        return substreamArr;
    }

    private void recusiveAddSubstreams(List<Integer> substreams) {
        substreams.add(this.streamNum);
        for (BaseAssemblyNode child : this.childNodes) {
            child.recusiveAddSubstreams(substreams);
        }
    }
}

