/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.base.JoinPreloadMethod;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposer;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.view.util.BufferView;
import java.util.HashSet;
import java.util.Set;

public class JoinPreloadMethodImpl
implements JoinPreloadMethod {
    private final int numStreams;
    private final BufferView[] bufferViews;
    private final JoinSetComposer joinSetComposer;

    public JoinPreloadMethodImpl(int numStreams, JoinSetComposer joinSetComposer) {
        this.numStreams = numStreams;
        this.bufferViews = new BufferView[numStreams];
        this.joinSetComposer = joinSetComposer;
    }

    @Override
    public void setBuffer(BufferView view, int stream) {
        this.bufferViews[stream] = view;
    }

    @Override
    public void preloadFromBuffer(int stream, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean[] preloadEvents = this.bufferViews[stream].getNewDataBuffer().getAndFlush();
        EventBean[][] eventsPerStream = new EventBean[this.numStreams][];
        eventsPerStream[stream] = preloadEvents;
        this.joinSetComposer.init(eventsPerStream, exprEvaluatorContext);
    }

    @Override
    public void preloadAggregation(ResultSetProcessor resultSetProcessor) {
        Set<MultiKeyArrayOfKeys<EventBean>> newEvents = this.joinSetComposer.staticJoin();
        HashSet<MultiKeyArrayOfKeys<EventBean>> oldEvents = new HashSet<MultiKeyArrayOfKeys<EventBean>>();
        resultSetProcessor.processJoinResult(newEvents, oldEvents, false);
    }

    @Override
    public boolean isPreloading() {
        return true;
    }
}

