/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.aifactory.select.StreamJoinAnalysisResultRuntime;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewable;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableIndexService;
import com.espertech.esper.common.internal.epl.index.base.EventTableUtil;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerAllUnidirectionalOuter;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerDesc;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerFAFImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerHistoricalImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerPrototypeBase;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerStreamToWinImpl;
import com.espertech.esper.common.internal.epl.join.base.JoinSetComposerUtil;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlan;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndex;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanNode;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNodeQueryStrategy;
import com.espertech.esper.common.internal.epl.join.strategy.QueryStrategy;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWQueryPlanUtil;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.type.NameAndModule;
import com.espertech.esper.common.internal.view.core.DerivedValueView;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinSetComposerPrototypeGeneral
extends JoinSetComposerPrototypeBase {
    public static final EPTypeClass EPTYPE = new EPTypeClass(JoinSetComposerPrototypeGeneral.class);
    private static final Logger log = LoggerFactory.getLogger(JoinSetComposerPrototypeGeneral.class);
    private StreamJoinAnalysisResultRuntime streamJoinAnalysisResult;
    private String[] streamNames;
    private QueryPlan queryPlan;
    private boolean joinRemoveStream;
    private EventTableIndexService eventTableIndexService;
    private boolean hasHistorical;

    public void setStreamJoinAnalysisResult(StreamJoinAnalysisResultRuntime streamJoinAnalysisResult) {
        this.streamJoinAnalysisResult = streamJoinAnalysisResult;
    }

    public void setStreamNames(String[] streamNames) {
        this.streamNames = streamNames;
    }

    public void setQueryPlan(QueryPlan queryPlan) {
        this.queryPlan = queryPlan;
    }

    public void setJoinRemoveStream(boolean joinRemoveStream) {
        this.joinRemoveStream = joinRemoveStream;
    }

    public void setEventTableIndexService(EventTableIndexService eventTableIndexService) {
        this.eventTableIndexService = eventTableIndexService;
    }

    public void setHasHistorical(boolean hasHistorical) {
        this.hasHistorical = hasHistorical;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JoinSetComposerDesc create(Viewable[] streamViews, boolean isFireAndForget, AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        void var12_23;
        void var12_19;
        QueryPlanIndex[] indexSpecs = this.queryPlan.getIndexSpecs();
        Map<Object, Object>[] indexesPerStream = new HashMap[indexSpecs.length];
        Lock[] tableSecondaryIndexLocks = new Lock[indexSpecs.length];
        boolean hasTable = false;
        for (int streamNo = 0; streamNo < indexSpecs.length; ++streamNo) {
            EventTable index;
            if (indexSpecs[streamNo] == null) continue;
            Map<TableLookupIndexReqKey, QueryPlanIndexItem> items = indexSpecs[streamNo].getItems();
            indexesPerStream[streamNo] = new LinkedHashMap();
            if (this.streamJoinAnalysisResult.getTables()[streamNo] != null) {
                Table table = this.streamJoinAnalysisResult.getTables()[streamNo];
                TableInstance tableInstance = table.getTableInstance(agentInstanceContext.getAgentInstanceId());
                for (NameAndModule indexName : tableInstance.getIndexRepository().getExplicitIndexNames()) {
                    EventTable index2 = tableInstance.getIndex(indexName.getName(), indexName.getModuleName());
                    indexesPerStream[streamNo].put(new TableLookupIndexReqKey(indexName.getName(), indexName.getModuleName(), table.getName()), index2);
                }
                index = tableInstance.getIndex(table.getName(), table.getMetaData().getTableModuleName());
                indexesPerStream[streamNo].put(new TableLookupIndexReqKey(table.getName(), table.getMetaData().getTableModuleName(), table.getName()), index);
                hasTable = true;
                tableSecondaryIndexLocks[streamNo] = agentInstanceContext.getStatementContext().getStatementInformationals().isWritesToTables() ? tableInstance.getTableLevelRWLock().writeLock() : tableInstance.getTableLevelRWLock().readLock();
                continue;
            }
            for (Map.Entry entry : items.entrySet()) {
                VirtualDWView virtualDWView = this.getNamedWindowVirtualDataWindow(streamNo, this.streamJoinAnalysisResult, agentInstanceContext);
                index = virtualDWView != null ? VirtualDWQueryPlanUtil.getJoinIndexTable(items.get(entry.getKey())) : EventTableUtil.buildIndex(agentInstanceContext, streamNo, items.get(entry.getKey()), this.streamTypes[streamNo], ((QueryPlanIndexItem)entry.getValue()).isUnique(), null, null, isFireAndForget);
                indexesPerStream[streamNo].put((TableLookupIndexReqKey)entry.getKey(), index);
            }
        }
        VirtualDWView[] externalViews = new VirtualDWView[indexSpecs.length];
        for (int i = 0; i < externalViews.length; ++i) {
            externalViews[i] = this.getNamedWindowVirtualDataWindow(i, this.streamJoinAnalysisResult, agentInstanceContext);
        }
        QueryPlanNode[] queryExecSpecs = this.queryPlan.getExecNodeSpecs();
        QueryStrategy[] queryStrategies = new QueryStrategy[queryExecSpecs.length];
        boolean bl = false;
        while (var12_19 < queryExecSpecs.length) {
            QueryPlanNode planNode = queryExecSpecs[var12_19];
            if (planNode == null) {
                log.debug(".makeComposer No execution node for stream " + (int)var12_19 + " '" + this.streamNames[var12_19] + "'");
            } else {
                ExecNode executionNode = planNode.makeExec(agentInstanceContext, indexesPerStream, this.streamTypes, streamViews, externalViews, tableSecondaryIndexLocks);
                if (log.isDebugEnabled()) {
                    log.debug(".makeComposer Execution nodes for stream " + (int)var12_19 + " '" + this.streamNames[var12_19] + "' : \n" + ExecNode.print(executionNode));
                }
                queryStrategies[var12_19] = new ExecNodeQueryStrategy((int)var12_19, this.streamTypes.length, executionNode);
            }
            ++var12_19;
        }
        if (hasTable) {
            indexesPerStream = this.removeTableIndexes(indexesPerStream, this.streamJoinAnalysisResult.getTables());
        }
        if (JoinSetComposerUtil.isNonUnidirectionalNonSelf(this.isOuterJoins, this.streamJoinAnalysisResult.isUnidirectional(), this.streamJoinAnalysisResult.isPureSelfJoin())) {
            composer = this.hasHistorical ? new JoinSetComposerHistoricalImpl(this.eventTableIndexService.allowInitIndex(isRecoveringResilient), indexesPerStream, queryStrategies, streamViews, agentInstanceContext) : (isFireAndForget ? new JoinSetComposerFAFImpl(indexesPerStream, queryStrategies, this.streamJoinAnalysisResult.isPureSelfJoin(), agentInstanceContext, this.joinRemoveStream, this.isOuterJoins) : new JoinSetComposerImpl(this.eventTableIndexService.allowInitIndex(isRecoveringResilient), indexesPerStream, queryStrategies, this.streamJoinAnalysisResult.isPureSelfJoin(), agentInstanceContext, this.joinRemoveStream));
            JoinSetComposerDesc joinSetComposerDesc = new JoinSetComposerDesc(composer, this.postJoinFilterEvaluator);
        } else if (this.streamJoinAnalysisResult.isUnidirectionalAll()) {
            composer = new JoinSetComposerAllUnidirectionalOuter(queryStrategies);
            JoinSetComposerDesc joinSetComposerDesc = new JoinSetComposerDesc(composer, this.postJoinFilterEvaluator);
        } else {
            QueryStrategy driver;
            int unidirectionalStream;
            if (this.streamJoinAnalysisResult.isUnidirectional()) {
                unidirectionalStream = this.streamJoinAnalysisResult.getUnidirectionalStreamNumberFirst();
                driver = queryStrategies[unidirectionalStream];
            } else {
                unidirectionalStream = 0;
                driver = queryStrategies[0];
            }
            JoinSetComposerStreamToWinImpl composer = new JoinSetComposerStreamToWinImpl(!isRecoveringResilient, indexesPerStream, this.streamJoinAnalysisResult.isPureSelfJoin(), unidirectionalStream, driver, this.streamJoinAnalysisResult.getUnidirectionalNonDriving());
            JoinSetComposerDesc joinSetComposerDesc = new JoinSetComposerDesc(composer, this.postJoinFilterEvaluator);
        }
        if (var12_23.getJoinSetComposer().allowsInit()) {
            EventBean[][] eventsPerStream = new EventBean[this.streamNames.length][];
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            for (int i = 0; i < eventsPerStream.length; ++i) {
                if (this.streamJoinAnalysisResult.getNamedWindows()[i] != null || this.streamJoinAnalysisResult.getTables()[i] != null) continue;
                Iterator<EventBean> it = null;
                if (!(streamViews[i] instanceof HistoricalEventViewable) && !(streamViews[i] instanceof DerivedValueView)) {
                    try {
                        it = streamViews[i].iterator();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                if (it != null) {
                    while (it.hasNext()) {
                        events.add((EventBean)it.next());
                    }
                    eventsPerStream[i] = events.toArray(new EventBean[events.size()]);
                    events.clear();
                    continue;
                }
                eventsPerStream[i] = new EventBean[0];
            }
            var12_23.getJoinSetComposer().init(eventsPerStream, agentInstanceContext);
        }
        return var12_23;
    }

    private VirtualDWView getNamedWindowVirtualDataWindow(int streamNo, StreamJoinAnalysisResultRuntime streamJoinAnalysisResult, AgentInstanceContext agentInstanceContext) {
        NamedWindow namedWindow = streamJoinAnalysisResult.getNamedWindows()[streamNo];
        if (namedWindow == null) {
            return null;
        }
        if (!namedWindow.getRootView().isVirtualDataWindow()) {
            return null;
        }
        NamedWindowInstance instance = namedWindow.getNamedWindowInstance(agentInstanceContext);
        return instance.getRootViewInstance().getVirtualDataWindow();
    }

    private Map<TableLookupIndexReqKey, EventTable>[] removeTableIndexes(Map<TableLookupIndexReqKey, EventTable>[] indexesPerStream, Table[] tablesPerStream) {
        Map[] result = new Map[indexesPerStream.length];
        for (int i = 0; i < indexesPerStream.length; ++i) {
            result[i] = tablesPerStream[i] == null ? indexesPerStream[i] : Collections.emptyMap();
        }
        return result;
    }
}

