/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.historical.common.HistoricalEventViewable;
import com.espertech.esper.common.internal.epl.historical.indexingstrategy.PollResultIndexingStrategy;
import com.espertech.esper.common.internal.epl.historical.lookupstrategy.HistoricalIndexLookupStrategy;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.join.rep.Node;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyDesc;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class HistoricalTableLookupStrategy
implements JoinExecTableLookupStrategy {
    private final HistoricalEventViewable viewable;
    private final PollResultIndexingStrategy indexingStrategy;
    private final HistoricalIndexLookupStrategy lookupStrategy;
    private final int streamNum;
    private final int rootStreamNum;
    private final ExprEvaluator outerJoinExprNode;
    private final EventBean[][] lookupEventsPerStream;

    public HistoricalTableLookupStrategy(HistoricalEventViewable viewable, PollResultIndexingStrategy indexingStrategy, HistoricalIndexLookupStrategy lookupStrategy, int numStreams, int streamNum, int rootStreamNum, ExprEvaluator outerJoinExprNode) {
        this.viewable = viewable;
        this.indexingStrategy = indexingStrategy;
        this.lookupStrategy = lookupStrategy;
        this.streamNum = streamNum;
        this.rootStreamNum = rootStreamNum;
        this.outerJoinExprNode = outerJoinExprNode;
        this.lookupEventsPerStream = new EventBean[1][numStreams];
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext exprEvaluatorContext) {
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qIndexJoinLookup(this, null);
        int currStream = cursor.getStream();
        this.lookupEventsPerStream[0][currStream] = theEvent;
        this.recursiveFill(this.lookupEventsPerStream[0], cursor.getNode());
        EventTable[][] indexPerLookupRow = this.viewable.poll(this.lookupEventsPerStream, this.indexingStrategy, exprEvaluatorContext);
        HashSet<EventBean> result = null;
        for (EventTable[] index : indexPerLookupRow) {
            EventBean candidate;
            Iterator<EventBean> subsetIter = this.lookupStrategy.lookup(theEvent, index, exprEvaluatorContext);
            if (subsetIter == null) continue;
            if (this.outerJoinExprNode != null) {
                while (subsetIter.hasNext()) {
                    this.lookupEventsPerStream[0][this.streamNum] = candidate = subsetIter.next();
                    Boolean pass = (Boolean)this.outerJoinExprNode.evaluate(this.lookupEventsPerStream[0], true, exprEvaluatorContext);
                    if (pass == null || !pass.booleanValue()) continue;
                    if (result == null) {
                        result = new HashSet();
                    }
                    result.add(candidate);
                }
                continue;
            }
            while (subsetIter.hasNext()) {
                candidate = subsetIter.next();
                if (result == null) {
                    result = new HashSet<EventBean>();
                }
                result.add(candidate);
            }
        }
        instrumentationCommon.aIndexJoinLookup(result, null);
        return result;
    }

    private void recursiveFill(EventBean[] lookupEventsPerStream, Node node) {
        if (node == null) {
            return;
        }
        Node parent = node.getParent();
        if (parent == null) {
            lookupEventsPerStream[this.rootStreamNum] = node.getParentEvent();
            return;
        }
        lookupEventsPerStream[parent.getStream()] = node.getParentEvent();
        this.recursiveFill(lookupEventsPerStream, parent);
    }

    public LookupStrategyDesc getStrategyDesc() {
        return null;
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.HISTORICAL;
    }
}

