/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.base;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.strategy.ExecNode;
import com.espertech.esper.common.internal.util.IndentWriter;
import java.util.Collection;
import java.util.LinkedList;

public class NestedIterationExecNode
extends ExecNode {
    private final LinkedList<ExecNode> childNodes;
    private final int[] nestedStreams;
    private int nestingOrderLength;

    public NestedIterationExecNode(int[] nestedStreams) {
        this.nestedStreams = nestedStreams;
        this.childNodes = new LinkedList();
    }

    public void addChildNode(ExecNode childNode) {
        this.childNodes.add(childNode);
    }

    @Override
    public void process(EventBean lookupEvent, EventBean[] prefillPath, Collection<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        this.nestingOrderLength = this.childNodes.size();
        this.recursiveNestedJoin(lookupEvent, 0, prefillPath, result, exprEvaluatorContext);
    }

    protected void recursiveNestedJoin(EventBean lookupEvent, int nestingOrderIndex, EventBean[] currentPath, Collection<EventBean[]> result, ExprEvaluatorContext exprEvaluatorContext) {
        boolean isLastStream;
        LinkedList<EventBean[]> nestedResult = new LinkedList<EventBean[]>();
        ExecNode nestedExecNode = this.childNodes.get(nestingOrderIndex);
        nestedExecNode.process(lookupEvent, currentPath, nestedResult, exprEvaluatorContext);
        boolean bl = isLastStream = nestingOrderIndex == this.nestingOrderLength - 1;
        if (!isLastStream) {
            for (EventBean[] row : nestedResult) {
                EventBean lookup = row[this.nestedStreams[nestingOrderIndex]];
                this.recursiveNestedJoin(lookup, nestingOrderIndex + 1, row, result, exprEvaluatorContext);
            }
            return;
        }
        for (EventBean[] row : nestedResult) {
            result.add(row);
        }
    }

    @Override
    public void print(IndentWriter writer) {
        writer.println("NestedIterationExecNode");
        writer.incrIndent();
        for (ExecNode child : this.childNodes) {
            child.print(writer);
        }
        writer.decrIndent();
    }
}

