/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.composite;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.common.internal.epl.join.exec.composite.CompositeIndexQueryResultPostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CompositeIndexQueryKeyed
implements CompositeIndexQuery {
    private final ExprEvaluator hashGetter;
    private final int lookupStream;
    private final EventBean[] events;
    private final boolean isNWOnTrigger;
    private CompositeIndexQuery next;

    public CompositeIndexQueryKeyed(boolean isNWOnTrigger, int lookupStream, int numStreams, ExprEvaluator hashGetter) {
        this.hashGetter = hashGetter;
        this.isNWOnTrigger = isNWOnTrigger;
        this.lookupStream = lookupStream;
        this.events = lookupStream != -1 ? new EventBean[lookupStream + 1] : new EventBean[numStreams + 1];
    }

    @Override
    public void setNext(CompositeIndexQuery next) {
        this.next = next;
    }

    @Override
    public Set<EventBean> get(EventBean theEvent, Map parent, ExprEvaluatorContext context, CompositeIndexQueryResultPostProcessor postProcessor) {
        this.events[this.lookupStream] = theEvent;
        Object mk = this.hashGetter.evaluate(this.events, true, context);
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.get(theEvent, innerIndex, context, postProcessor);
    }

    @Override
    public Set<EventBean> getCollectKeys(EventBean theEvent, Map parent, ExprEvaluatorContext context, ArrayList<Object> keys, CompositeIndexQueryResultPostProcessor postProcessor) {
        this.events[this.lookupStream] = theEvent;
        Object mk = this.hashGetter.evaluate(this.events, true, context);
        if (mk instanceof MultiKeyArrayOfKeys) {
            Collections.addAll(keys, ((MultiKeyArrayOfKeys)mk).getArray());
        } else {
            Collections.addAll(keys, mk);
        }
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.getCollectKeys(theEvent, innerIndex, context, keys, postProcessor);
    }

    @Override
    public Collection<EventBean> get(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context, CompositeIndexQueryResultPostProcessor postProcessor) {
        EventBean[] eventsToUse;
        if (this.isNWOnTrigger) {
            eventsToUse = eventsPerStream;
        } else {
            System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
            eventsToUse = this.events;
        }
        Object mk = this.hashGetter.evaluate(eventsToUse, true, context);
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.get(eventsPerStream, innerIndex, context, postProcessor);
    }

    @Override
    public Collection<EventBean> getCollectKeys(EventBean[] eventsPerStream, Map parent, ExprEvaluatorContext context, ArrayList<Object> keys, CompositeIndexQueryResultPostProcessor postProcessor) {
        EventBean[] eventsToUse;
        if (this.isNWOnTrigger) {
            eventsToUse = eventsPerStream;
        } else {
            System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
            eventsToUse = this.events;
        }
        Object mk = this.hashGetter.evaluate(eventsToUse, true, context);
        if (mk instanceof MultiKeyArrayOfKeys) {
            Collections.addAll(keys, ((MultiKeyArrayOfKeys)mk).getArray());
        } else {
            Collections.addAll(keys, mk);
        }
        Map innerIndex = (Map)parent.get(mk);
        if (innerIndex == null) {
            return null;
        }
        return this.next.getCollectKeys(eventsPerStream, innerIndex, context, keys, postProcessor);
    }

    @Override
    public void add(EventBean theEvent, Map value, Set<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(EventBean[] eventsPerStream, Map value, Collection<EventBean> result, CompositeIndexQueryResultPostProcessor postProcessor) {
        throw new UnsupportedOperationException();
    }
}

