/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.composite;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.index.composite.PropertyCompositeEventTable;
import com.espertech.esper.common.internal.epl.join.exec.base.JoinExecTableLookupStrategy;
import com.espertech.esper.common.internal.epl.join.exec.composite.CompositeIndexQuery;
import com.espertech.esper.common.internal.epl.join.exec.composite.CompositeIndexQueryFactory;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRange;
import com.espertech.esper.common.internal.epl.join.rep.Cursor;
import com.espertech.esper.common.internal.epl.lookup.LookupStrategyType;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class CompositeTableLookupStrategy
implements JoinExecTableLookupStrategy {
    private final EventType eventType;
    private final PropertyCompositeEventTable index;
    private final CompositeIndexQuery chain;

    public CompositeTableLookupStrategy(EventType eventType, int lookupStream, ExprEvaluator hashKeys, QueryGraphValueEntryRange[] rangeKeyPairs, PropertyCompositeEventTable index) {
        this.eventType = eventType;
        this.index = index;
        this.chain = CompositeIndexQueryFactory.makeJoinSingleLookupStream(false, lookupStream, hashKeys, rangeKeyPairs);
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public PropertyCompositeEventTable getIndex() {
        return this.index;
    }

    @Override
    public Set<EventBean> lookup(EventBean theEvent, Cursor cursor, ExprEvaluatorContext context) {
        InstrumentationCommon instrumentationCommon = context.getInstrumentationProvider();
        if (instrumentationCommon.activated()) {
            instrumentationCommon.qIndexJoinLookup(this, this.index);
            ArrayList<Object> keys = new ArrayList<Object>(2);
            Set<EventBean> result = this.chain.getCollectKeys(theEvent, (Map)this.index.getIndex(), context, keys, this.index.getPostProcessor());
            instrumentationCommon.aIndexJoinLookup(result, keys.size() > 1 ? keys.toArray() : keys.get(0));
            return result;
        }
        Set<EventBean> result = this.chain.get(theEvent, (Map)this.index.getIndex(), context, this.index.getPostProcessor());
        if (result != null && result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public LookupStrategyType getLookupStrategyType() {
        return LookupStrategyType.COMPOSITE;
    }
}

