/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.exec.sorted;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;

public abstract class SortedAccessStrategyRelOpBase {
    private final ExprEvaluator keyEval;
    private final EventBean[] events;
    private final int lookupStream;
    private final boolean isNWOnTrigger;

    protected SortedAccessStrategyRelOpBase(boolean isNWOnTrigger, int lookupStream, int numStreams, ExprEvaluator keyEval) {
        this.lookupStream = lookupStream;
        this.keyEval = keyEval;
        this.isNWOnTrigger = isNWOnTrigger;
        this.events = lookupStream != -1 ? new EventBean[lookupStream + 1] : new EventBean[numStreams + 1];
    }

    public Object evaluateLookup(EventBean theEvent, ExprEvaluatorContext context) {
        this.events[this.lookupStream] = theEvent;
        return this.keyEval.evaluate(this.events, true, context);
    }

    public Object evaluatePerStream(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        if (this.isNWOnTrigger) {
            return this.keyEval.evaluate(eventsPerStream, true, context);
        }
        System.arraycopy(eventsPerStream, 0, this.events, 1, eventsPerStream.length);
        return this.keyEval.evaluate(this.events, true, context);
    }

    public String toQueryPlan() {
        return this.getClass().getSimpleName() + " key " + this.keyEval.getClass().getSimpleName();
    }
}

