/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.querygraph;

import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.type.RelationalOpEnum;

public enum QueryGraphRangeEnum {
    LESS(false, "<"),
    LESS_OR_EQUAL(false, "<="),
    GREATER_OR_EQUAL(false, ">="),
    GREATER(false, ">"),
    RANGE_OPEN(true, "(,)"),
    RANGE_CLOSED(true, "[,]"),
    RANGE_HALF_OPEN(true, "[,)"),
    RANGE_HALF_CLOSED(true, "(,]"),
    NOT_RANGE_OPEN(true, "-(,)"),
    NOT_RANGE_CLOSED(true, "-[,]"),
    NOT_RANGE_HALF_OPEN(true, "-[,)"),
    NOT_RANGE_HALF_CLOSED(true, "-(,]");

    private boolean range;
    private String stringOp;

    private QueryGraphRangeEnum(boolean range, String stringOp) {
        this.range = range;
        this.stringOp = stringOp;
    }

    public static QueryGraphRangeEnum mapFrom(FilterOperator op) {
        if (op == FilterOperator.GREATER) {
            return GREATER;
        }
        if (op == FilterOperator.GREATER_OR_EQUAL) {
            return GREATER_OR_EQUAL;
        }
        if (op == FilterOperator.LESS) {
            return LESS;
        }
        if (op == FilterOperator.LESS_OR_EQUAL) {
            return LESS_OR_EQUAL;
        }
        if (op == FilterOperator.RANGE_OPEN) {
            return RANGE_OPEN;
        }
        if (op == FilterOperator.RANGE_HALF_CLOSED) {
            return RANGE_HALF_CLOSED;
        }
        if (op == FilterOperator.RANGE_HALF_OPEN) {
            return RANGE_HALF_OPEN;
        }
        if (op == FilterOperator.RANGE_CLOSED) {
            return RANGE_CLOSED;
        }
        if (op == FilterOperator.NOT_RANGE_OPEN) {
            return NOT_RANGE_OPEN;
        }
        if (op == FilterOperator.NOT_RANGE_HALF_CLOSED) {
            return NOT_RANGE_HALF_CLOSED;
        }
        if (op == FilterOperator.NOT_RANGE_HALF_OPEN) {
            return NOT_RANGE_HALF_OPEN;
        }
        if (op == FilterOperator.NOT_RANGE_CLOSED) {
            return NOT_RANGE_CLOSED;
        }
        return null;
    }

    public static QueryGraphRangeEnum mapFrom(RelationalOpEnum relationalOpEnum) {
        if (relationalOpEnum == RelationalOpEnum.GE) {
            return GREATER_OR_EQUAL;
        }
        if (relationalOpEnum == RelationalOpEnum.GT) {
            return GREATER;
        }
        if (relationalOpEnum == RelationalOpEnum.LT) {
            return LESS;
        }
        if (relationalOpEnum == RelationalOpEnum.LE) {
            return LESS_OR_EQUAL;
        }
        throw new IllegalArgumentException("Failed to map code " + relationalOpEnum);
    }

    public boolean isRange() {
        return this.range;
    }

    public boolean isIncludeStart() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("Cannot determine endpoint-start included for op " + this);
        }
        return this == RANGE_HALF_OPEN || this == RANGE_CLOSED || this == NOT_RANGE_HALF_OPEN || this == NOT_RANGE_CLOSED;
    }

    public boolean isIncludeEnd() {
        if (!this.isRange()) {
            throw new UnsupportedOperationException("Cannot determine endpoint-end included for op " + this);
        }
        return this == RANGE_HALF_CLOSED || this == RANGE_CLOSED || this == NOT_RANGE_HALF_CLOSED || this == NOT_RANGE_CLOSED;
    }

    public static QueryGraphRangeEnum getRangeOp(boolean includeStart, boolean includeEnd, boolean isInverted) {
        if (!isInverted) {
            if (includeStart) {
                if (includeEnd) {
                    return RANGE_CLOSED;
                }
                return RANGE_HALF_OPEN;
            }
            if (includeEnd) {
                return RANGE_HALF_CLOSED;
            }
            return RANGE_OPEN;
        }
        if (includeStart) {
            if (includeEnd) {
                return NOT_RANGE_CLOSED;
            }
            return NOT_RANGE_HALF_OPEN;
        }
        if (includeEnd) {
            return NOT_RANGE_HALF_CLOSED;
        }
        return NOT_RANGE_OPEN;
    }

    public boolean isRangeInverted() {
        return this.isRange() && (this == NOT_RANGE_HALF_CLOSED || this == NOT_RANGE_HALF_OPEN || this == NOT_RANGE_OPEN || this == NOT_RANGE_CLOSED);
    }

    public String getStringOp() {
        return this.stringOp;
    }
}

