/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeExpr;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForgeProp;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeInForge;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryRangeRelOpForge;
import com.espertech.esper.common.internal.epl.join.queryplan.CoercionDesc;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropHashKeyForge;
import com.espertech.esper.common.internal.epl.lookupplan.SubordPropRangeKeyForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.List;
import java.util.Map;

public class CoercionUtil {
    private static final EPTypeClass[] NULL_ARRAY = new EPTypeClass[0];

    public static CoercionDesc getCoercionTypesRange(EventType[] typesPerStream, int indexedStream, String[] indexedProp, List<QueryGraphValueEntryRangeForge> rangeEntries) {
        if (rangeEntries.isEmpty()) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        EPTypeClass[] coercionTypes = new EPTypeClass[rangeEntries.size()];
        boolean mustCoerce = false;
        for (int i = 0; i < rangeEntries.size(); ++i) {
            EPTypeClass coercionType;
            QueryGraphValueEntryRangeForge entry = rangeEntries.get(i);
            String indexed = indexedProp[i];
            EPType valuePropType = JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyEPType(indexed));
            if (entry.getType().isRange()) {
                QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)entry;
                coercionType = CoercionUtil.getCoercionTypeRangeIn(valuePropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
            } else {
                QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)entry;
                coercionType = CoercionUtil.getCoercionType(valuePropType, relOp.getExpression().getForge().getEvaluationType());
            }
            if (coercionType == null) {
                coercionTypes[i] = valuePropType == EPTypeNull.INSTANCE ? null : (EPTypeClass)valuePropType;
                continue;
            }
            mustCoerce = true;
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static CoercionDesc getCoercionTypesHash(EventType[] typesPerStream, int lookupStream, int indexedStream, List<QueryGraphValueEntryHashKeyedForge> keyProps, String[] indexProps) {
        if (indexProps.length == 0 && keyProps.size() == 0) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        if (indexProps.length != keyProps.size()) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        EPTypeClass[] coercionTypes = new EPTypeClass[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < keyProps.size(); ++i) {
            EPTypeClass indexedPropType;
            EPType keyPropType;
            if (keyProps.get(i) instanceof QueryGraphValueEntryHashKeyedForgeExpr) {
                QueryGraphValueEntryHashKeyedForgeExpr hashExpr = (QueryGraphValueEntryHashKeyedForgeExpr)keyProps.get(i);
                keyPropType = hashExpr.getKeyExpr().getForge().getEvaluationType();
            } else {
                QueryGraphValueEntryHashKeyedForgeProp hashKeyProp = (QueryGraphValueEntryHashKeyedForgeProp)keyProps.get(i);
                keyPropType = JavaClassHelper.getBoxedType(typesPerStream[lookupStream].getPropertyEPType(hashKeyProp.getKeyProperty()));
            }
            EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(typesPerStream[indexedStream].getPropertyEPType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static CoercionDesc getCoercionTypesRange(EventType viewableEventType, Map<String, SubordPropRangeKeyForge> rangeProps, EventType[] typesPerStream) {
        if (rangeProps.isEmpty()) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        EPTypeClass[] coercionTypes = new EPTypeClass[rangeProps.size()];
        boolean mustCoerce = false;
        int count = 0;
        for (Map.Entry<String, SubordPropRangeKeyForge> entry : rangeProps.entrySet()) {
            EPTypeClass coercionType;
            SubordPropRangeKeyForge subQRange = entry.getValue();
            QueryGraphValueEntryRangeForge rangeDesc = entry.getValue().getRangeInfo();
            EPType valuePropType = JavaClassHelper.getBoxedType(viewableEventType.getPropertyEPType(entry.getKey()));
            if (rangeDesc.getType().isRange()) {
                QueryGraphValueEntryRangeInForge rangeIn = (QueryGraphValueEntryRangeInForge)rangeDesc;
                coercionType = CoercionUtil.getCoercionTypeRangeIn(valuePropType, rangeIn.getExprStart(), rangeIn.getExprEnd());
            } else {
                QueryGraphValueEntryRangeRelOpForge relOp = (QueryGraphValueEntryRangeRelOpForge)rangeDesc;
                coercionType = CoercionUtil.getCoercionType(valuePropType, relOp.getExpression().getForge().getEvaluationType());
            }
            if (coercionType == null) {
                coercionTypes[count++] = valuePropType == EPTypeNull.INSTANCE ? null : (EPTypeClass)valuePropType;
                continue;
            }
            mustCoerce = true;
            coercionTypes[count++] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    private static EPTypeClass getCoercionType(EPType valuePropType, EPType keyPropTypeExpr) {
        EPTypeClass coercionType = null;
        EPType keyPropType = JavaClassHelper.getBoxedType(keyPropTypeExpr);
        if (!valuePropType.equals(keyPropType)) {
            coercionType = JavaClassHelper.getCompareToCoercionType(valuePropType, keyPropType);
        }
        return coercionType;
    }

    public static CoercionDesc getCoercionTypesHash(EventType viewableEventType, String[] indexProps, List<SubordPropHashKeyForge> hashKeys) {
        if (indexProps.length == 0 && hashKeys.size() == 0) {
            return new CoercionDesc(false, NULL_ARRAY);
        }
        if (indexProps.length != hashKeys.size()) {
            throw new IllegalStateException("Mismatch in the number of key and index properties");
        }
        EPTypeClass[] coercionTypes = new EPTypeClass[indexProps.length];
        boolean mustCoerce = false;
        for (int i = 0; i < hashKeys.size(); ++i) {
            EPTypeClass indexedPropType;
            EPType keyPropType = JavaClassHelper.getBoxedType(hashKeys.get(i).getHashKey().getKeyExpr().getForge().getEvaluationType());
            EPTypeClass coercionType = indexedPropType = (EPTypeClass)JavaClassHelper.getBoxedType(viewableEventType.getPropertyEPType(indexProps[i]));
            if (keyPropType != indexedPropType) {
                coercionType = JavaClassHelper.getCompareToCoercionType(keyPropType, indexedPropType);
                mustCoerce = true;
            }
            coercionTypes[i] = coercionType;
        }
        return new CoercionDesc(mustCoerce, coercionTypes);
    }

    public static EPTypeClass getCoercionTypeRangeIn(EPType valuePropType, ExprNode exprStart, ExprNode exprEnd) {
        EPTypeClass coercionType = null;
        EPType startPropType = JavaClassHelper.getBoxedType(exprStart.getForge().getEvaluationType());
        EPType endPropType = JavaClassHelper.getBoxedType(exprEnd.getForge().getEvaluationType());
        if (!valuePropType.equals(startPropType)) {
            coercionType = JavaClassHelper.getCompareToCoercionType(valuePropType, startPropType);
        }
        if (!valuePropType.equals(endPropType)) {
            coercionType = JavaClassHelper.getCompareToCoercionType(coercionType, endPropType);
        }
        if (coercionType == null) {
            return null;
        }
        return coercionType;
    }

    public static EPTypeClass[] getCoercionTypes(EPType[] propTypes) {
        EPTypeClass[] classes = new EPTypeClass[propTypes.length];
        for (int i = 0; i < propTypes.length; ++i) {
            EPType type = propTypes[i];
            classes[i] = type == null || type == EPTypeNull.INSTANCE ? null : (EPTypeClass)type;
        }
        return classes;
    }
}

