/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeable;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenMakeableUtil;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndex;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItemForge;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexUniqueHelper;
import com.espertech.esper.common.internal.epl.join.queryplan.TableLookupIndexReqKey;
import com.espertech.esper.common.internal.util.UuidGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryPlanIndexForge
implements CodegenMakeable<SAIFFInitializeSymbol> {
    private Map<TableLookupIndexReqKey, QueryPlanIndexItemForge> items;

    public QueryPlanIndexForge(Map<TableLookupIndexReqKey, QueryPlanIndexItemForge> items) {
        if (items == null) {
            throw new IllegalArgumentException("Null value not allowed for items");
        }
        this.items = items;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return CodegenExpressionBuilder.newInstance(QueryPlanIndex.EPTYPE, CodegenMakeableUtil.makeMap("items", TableLookupIndexReqKey.EPTYPE, QueryPlanIndexItem.EPTYPE, this.items, this.getClass(), parent, symbols, classScope));
    }

    public Map<TableLookupIndexReqKey, QueryPlanIndexItemForge> getItems() {
        return this.items;
    }

    public static QueryPlanIndexForge makeIndex(List<QueryPlanIndexItemForge> indexesSet) {
        LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItemForge> items = new LinkedHashMap<TableLookupIndexReqKey, QueryPlanIndexItemForge>();
        for (QueryPlanIndexItemForge item : indexesSet) {
            items.put(new TableLookupIndexReqKey(UuidGenerator.generate(), null), item);
        }
        return new QueryPlanIndexForge(items);
    }

    public Pair<TableLookupIndexReqKey, int[]> getIndexNum(String[] indexProps, String[] rangeProps) {
        QueryPlanIndexItemForge proposed = new QueryPlanIndexItemForge(indexProps, new EPTypeClass[indexProps.length], rangeProps, new EPTypeClass[rangeProps.length], false, null, null);
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            if (!entry.getValue().equalsCompareSortedProps(proposed)) continue;
            return new Pair<TableLookupIndexReqKey, Object>(entry.getKey(), null);
        }
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            int[] indexes;
            if (entry.getValue().getRangeProps() != null && entry.getValue().getRangeProps().length != 0 || (indexes = QueryPlanIndexUniqueHelper.checkSufficientGetAssignment(entry.getValue().getHashProps(), indexProps)) == null || indexes.length == 0) continue;
            return new Pair<TableLookupIndexReqKey, int[]>(entry.getKey(), indexes);
        }
        return null;
    }

    protected TableLookupIndexReqKey getFirstIndexNum() {
        return this.items.keySet().iterator().next();
    }

    public String addIndex(String[] indexProperties, EPTypeClass[] coercionTypes, EventType eventType) {
        String uuid = UuidGenerator.generate();
        this.items.put(new TableLookupIndexReqKey(uuid, null), new QueryPlanIndexItemForge(indexProperties, coercionTypes, new String[0], new EPTypeClass[0], false, null, eventType));
        return uuid;
    }

    public String[][] getIndexProps() {
        String[][] arr = new String[this.items.size()][];
        int count = 0;
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            arr[count] = entry.getValue().getHashProps();
            ++count;
        }
        return arr;
    }

    public EPTypeClass[] getCoercionTypes(String[] indexProperties) {
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getHashProps(), indexProperties)) continue;
            return entry.getValue().getHashTypes();
        }
        throw new IllegalArgumentException("Index properties not found");
    }

    public void setCoercionTypes(String[] indexProperties, EPTypeClass[] coercionTypes) {
        boolean found = false;
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            if (!Arrays.deepEquals(entry.getValue().getHashProps(), indexProperties)) continue;
            entry.getValue().setHashTypes(coercionTypes);
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("Index properties not found");
        }
    }

    public String toString() {
        if (this.items.isEmpty()) {
            return "    (none)";
        }
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<TableLookupIndexReqKey, QueryPlanIndexItemForge> entry : this.items.entrySet()) {
            buf.append(delimiter);
            String info = entry.getValue() == null ? "" : " : " + entry.getValue();
            buf.append("    index " + entry.getKey() + info);
            delimiter = "\n";
        }
        return buf.toString();
    }

    public static String print(QueryPlanIndexForge[] indexSpecs) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("QueryPlanIndex[]\n");
        String delimiter = "";
        for (int i = 0; i < indexSpecs.length; ++i) {
            buffer.append(delimiter);
            buffer.append("  index spec stream " + i + " : \n" + (indexSpecs[i] == null ? "    null" : indexSpecs[i]));
            delimiter = "\n";
        }
        return buffer.toString() + "\n";
    }

    public static QueryPlanIndexForge makeIndexTableAccess(TableLookupIndexReqKey indexName) {
        HashMap<TableLookupIndexReqKey, QueryPlanIndexItemForge> indexMap = new HashMap<TableLookupIndexReqKey, QueryPlanIndexItemForge>();
        indexMap.put(indexName, null);
        return new QueryPlanIndexForge(indexMap);
    }
}

