/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.join.queryplan;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphValueEntryHashKeyedForge;
import java.util.ArrayList;
import java.util.List;

public class QueryPlanIndexUniqueHelper {
    public static ReducedHashKeys reduceToUniqueIfPossible(String[] hashPropsProvided, EPTypeClass[] hashCoercionTypes, List<QueryGraphValueEntryHashKeyedForge> hashFunctions, String[][] hashPropsRequiredPerIndex) {
        if (hashPropsRequiredPerIndex == null || hashPropsRequiredPerIndex.length == 0) {
            return null;
        }
        for (String[] hashPropsRequired : hashPropsRequiredPerIndex) {
            int[] indexes = QueryPlanIndexUniqueHelper.checkSufficientGetAssignment(hashPropsRequired, hashPropsProvided);
            if (indexes == null) continue;
            String[] props = new String[indexes.length];
            EPTypeClass[] types = new EPTypeClass[indexes.length];
            ArrayList<QueryGraphValueEntryHashKeyedForge> functions = new ArrayList<QueryGraphValueEntryHashKeyedForge>();
            for (int i = 0; i < indexes.length; ++i) {
                props[i] = hashPropsProvided[indexes[i]];
                types[i] = hashCoercionTypes == null ? null : hashCoercionTypes[indexes[i]];
                functions.add(hashFunctions.get(indexes[i]));
            }
            return new ReducedHashKeys(props, types, functions);
        }
        return null;
    }

    public static int[] checkSufficientGetAssignment(String[] hashPropsRequired, String[] hashPropsProvided) {
        if (hashPropsProvided == null || hashPropsRequired == null || hashPropsProvided.length < hashPropsRequired.length) {
            return null;
        }
        for (String required : hashPropsRequired) {
            boolean found = false;
            for (String provided : hashPropsProvided) {
                if (!provided.equals(required)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        int[] indexes = new int[hashPropsRequired.length];
        for (int i = 0; i < indexes.length; ++i) {
            String required;
            int foundIndex = -1;
            required = hashPropsRequired[i];
            for (int j = 0; j < hashPropsProvided.length; ++j) {
                if (!hashPropsProvided[j].equals(required)) continue;
                foundIndex = j;
                break;
            }
            indexes[i] = foundIndex;
        }
        return indexes;
    }

    public static class ReducedHashKeys {
        private final String[] propertyNames;
        private final EPTypeClass[] coercionTypes;
        private final List<QueryGraphValueEntryHashKeyedForge> hashKeyFunctions;

        private ReducedHashKeys(String[] propertyNames, EPTypeClass[] coercionTypes, List<QueryGraphValueEntryHashKeyedForge> hashKeyFunctions) {
            this.propertyNames = propertyNames;
            this.coercionTypes = coercionTypes;
            this.hashKeyFunctions = hashKeyFunctions;
        }

        public String[] getPropertyNames() {
            return this.propertyNames;
        }

        public EPTypeClass[] getCoercionTypes() {
            return this.coercionTypes;
        }

        public List<QueryGraphValueEntryHashKeyedForge> getHashKeyFunctions() {
            return this.hashKeyFunctions;
        }
    }
}

