/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowDeployment;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowManagementService;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class NamedWindowManagementServiceImpl
implements NamedWindowManagementService {
    private final Map<String, NamedWindowDeployment> deployments = new HashMap<String, NamedWindowDeployment>();

    @Override
    public void addNamedWindow(String windowName, NamedWindowMetaData metadata, EPStatementInitServices services) {
        NamedWindowDeployment deployment = this.deployments.get(services.getDeploymentId());
        if (deployment == null) {
            deployment = new NamedWindowDeployment();
            this.deployments.put(services.getDeploymentId(), deployment);
        }
        deployment.add(windowName, metadata, services);
    }

    @Override
    public NamedWindow getNamedWindow(String deploymentId, String namedWindowName) {
        NamedWindowDeployment deployment = this.deployments.get(deploymentId);
        return deployment == null ? null : deployment.getProcessor(namedWindowName);
    }

    @Override
    public int getDeploymentCount() {
        return this.deployments.size();
    }

    @Override
    public void destroyNamedWindow(String deploymentId, String namedWindowName) {
        NamedWindowDeployment deployment = this.deployments.get(deploymentId);
        if (deployment == null) {
            return;
        }
        deployment.remove(namedWindowName);
        if (deployment.isEmpty()) {
            this.deployments.remove(deploymentId);
        }
    }

    @Override
    public void traverseNamedWindows(BiConsumer<String, NamedWindow> consumer) {
        for (Map.Entry<String, NamedWindowDeployment> entry : this.deployments.entrySet()) {
            for (Map.Entry<String, NamedWindow> nw : entry.getValue().getNamedWindows().entrySet()) {
                consumer.accept(entry.getKey(), nw.getValue());
            }
        }
    }
}

