/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.fafquery.processor.FireAndForgetQueryExec;
import com.espertech.esper.common.internal.epl.index.base.EventTable;
import com.espertech.esper.common.internal.epl.index.base.EventTableUtil;
import com.espertech.esper.common.internal.epl.index.base.EventTableVisitor;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraph;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadata;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexMetadataEntry;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepository;
import com.espertech.esper.common.internal.epl.lookupplansubord.EventTableIndexRepositoryEntry;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootView;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.core.Viewable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class NamedWindowRootViewInstance
extends ViewSupport {
    private final NamedWindowRootView rootView;
    private final AgentInstanceContext agentInstanceContext;
    private final EventTableIndexRepository indexRepository;
    private Iterable<EventBean> dataWindowContents;

    public NamedWindowRootViewInstance(NamedWindowRootView rootView, AgentInstanceContext agentInstanceContext, EventTableIndexMetadata eventTableIndexMetadata) {
        this.rootView = rootView;
        this.agentInstanceContext = agentInstanceContext;
        this.indexRepository = new EventTableIndexRepository(eventTableIndexMetadata);
        for (Map.Entry<IndexMultiKey, EventTableIndexMetadataEntry> entry : eventTableIndexMetadata.getIndexes().entrySet()) {
            if (entry.getValue().getOptionalQueryPlanIndexItem() == null) continue;
            EventTable index = EventTableUtil.buildIndex(agentInstanceContext, 0, entry.getValue().getOptionalQueryPlanIndexItem(), rootView.getEventType(), entry.getKey().isUnique(), entry.getValue().getOptionalIndexName(), null, false);
            this.indexRepository.addIndex(entry.getKey(), new EventTableIndexRepositoryEntry(entry.getValue().getOptionalIndexName(), entry.getValue().getOptionalIndexModuleName(), index));
        }
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public IndexMultiKey[] getIndexes() {
        return this.indexRepository.getIndexDescriptors();
    }

    public Iterable<EventBean> getDataWindowContents() {
        return this.dataWindowContents;
    }

    public void setDataWindowContents(Iterable<EventBean> dataWindowContents) {
        this.dataWindowContents = dataWindowContents;
    }

    public void removeOldData(EventBean[] oldData) {
        for (EventTable table : this.indexRepository.getTables()) {
            table.remove(oldData, (ExprEvaluatorContext)this.agentInstanceContext);
        }
    }

    public void addNewData(EventBean[] newData) {
        for (EventTable table : this.indexRepository.getTables()) {
            table.add(newData, (ExprEvaluatorContext)this.agentInstanceContext);
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (this.rootView.isChildBatching()) {
            for (EventTable table : this.indexRepository.getTables()) {
                table.add(newData, (ExprEvaluatorContext)this.agentInstanceContext);
            }
        }
        this.child.update(newData, oldData);
    }

    @Override
    public void setParent(Viewable parent) {
        super.setParent(parent);
    }

    @Override
    public EventType getEventType() {
        return this.rootView.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return null;
    }

    public void destroy() {
        this.indexRepository.destroy();
        if (this.isVirtualDataWindow()) {
            this.getVirtualDataWindow().handleDestroy(this.agentInstanceContext.getAgentInstanceId());
        }
    }

    public Collection<EventBean> snapshot(QueryGraph queryGraph, Annotation[] annotations) {
        VirtualDWView virtualDataWindow = null;
        if (this.isVirtualDataWindow()) {
            virtualDataWindow = this.getVirtualDataWindow();
        }
        return FireAndForgetQueryExec.snapshot(queryGraph, annotations, virtualDataWindow, this.indexRepository, this.rootView.getEventType().getName(), this.agentInstanceContext);
    }

    public synchronized void addExplicitIndex(String explicitIndexName, String explicitIndexModuleName, QueryPlanIndexItem explicitIndexDesc, boolean isRecoveringResilient) throws ExprValidationException {
        boolean initIndex = this.agentInstanceContext.getStatementContext().getEventTableIndexService().allowInitIndex(isRecoveringResilient);
        Iterable<EventBean> initializeFrom = initIndex ? this.dataWindowContents : CollectionUtil.NULL_EVENT_ITERABLE;
        this.indexRepository.validateAddExplicitIndex(explicitIndexName, explicitIndexModuleName, explicitIndexDesc, this.rootView.getEventType(), initializeFrom, this.agentInstanceContext, isRecoveringResilient, null);
    }

    public void visitIndexes(EventTableVisitor visitor) {
        visitor.visit(this.indexRepository.getTables());
    }

    public boolean isParentBatchWindow() {
        return this.rootView.isChildBatching();
    }

    public EventTableIndexRepository getIndexRepository() {
        return this.indexRepository;
    }

    public boolean isVirtualDataWindow() {
        return this.child instanceof VirtualDWView;
    }

    public VirtualDWView getVirtualDataWindow() {
        if (!this.isVirtualDataWindow()) {
            return null;
        }
        return (VirtualDWView)((Object)this.child);
    }

    public void clearDeliveriesRemoveStream(EventBean[] removedEvents) {
        this.agentInstanceContext.getStatementResultService().clearDeliveriesRemoveStream(removedEvents);
    }
}

