/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.namedwindow.path;

import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PathException;
import com.espertech.esper.common.internal.collection.PathRegistry;
import com.espertech.esper.common.internal.collection.PathRegistryObjectType;
import com.espertech.esper.common.internal.context.module.ModuleDependenciesCompileTime;
import com.espertech.esper.common.internal.epl.namedwindow.compile.NamedWindowCompileTimeRegistry;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowCompileTimeResolver;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.util.CompileTimeResolver;
import java.util.Set;

public class NamedWindowCompileTimeResolverImpl
implements NamedWindowCompileTimeResolver {
    private final String moduleName;
    private final Set<String> moduleUses;
    private final NamedWindowCompileTimeRegistry locals;
    private final PathRegistry<String, NamedWindowMetaData> path;
    private final ModuleDependenciesCompileTime moduleDependencies;
    private final boolean isFireAndForget;

    public NamedWindowCompileTimeResolverImpl(String moduleName, Set<String> moduleUses, NamedWindowCompileTimeRegistry locals, PathRegistry<String, NamedWindowMetaData> path, ModuleDependenciesCompileTime moduleDependencies, boolean isFireAndForget) {
        this.moduleName = moduleName;
        this.moduleUses = moduleUses;
        this.locals = locals;
        this.path = path;
        this.moduleDependencies = moduleDependencies;
        this.isFireAndForget = isFireAndForget;
    }

    @Override
    public NamedWindowMetaData resolve(String namedWindowName) {
        NamedWindowMetaData localNamedWindow = this.locals.getNamedWindows().get(namedWindowName);
        if (localNamedWindow != null) {
            return localNamedWindow;
        }
        try {
            Pair<NamedWindowMetaData, String> pair = this.path.getAnyModuleExpectSingle(namedWindowName, this.moduleUses);
            if (pair != null) {
                if (!this.isFireAndForget && !NameAccessModifier.visible(pair.getFirst().getEventType().getMetadata().getAccessModifier(), pair.getFirst().getNamedWindowModuleName(), this.moduleName)) {
                    return null;
                }
                this.moduleDependencies.addPathNamedWindow(namedWindowName, pair.getSecond());
                return pair.getFirst();
            }
        }
        catch (PathException e) {
            throw CompileTimeResolver.makePathAmbiguous(PathRegistryObjectType.NAMEDWINDOW, namedWindowName, e);
        }
        return null;
    }
}

