/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeAction;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewTableChangeHandler;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessor;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;

public class InfraOnMergeActionIns
extends InfraOnMergeAction {
    public static final EPTypeClass EPTYPE = new EPTypeClass(InfraOnMergeActionIns.class);
    private final SelectExprProcessor insertHelper;
    private final Table insertIntoTable;
    private final boolean audit;
    private final boolean route;
    private final ExprEvaluator eventPrecedence;

    public InfraOnMergeActionIns(ExprEvaluator optionalFilter, SelectExprProcessor insertHelper, Table insertIntoTable, boolean audit, boolean route, ExprEvaluator eventPrecedence) {
        super(optionalFilter);
        this.insertHelper = insertHelper;
        this.insertIntoTable = insertIntoTable;
        this.audit = audit;
        this.route = route;
        this.eventPrecedence = eventPrecedence;
    }

    @Override
    public void apply(EventBean matchingEvent, EventBean[] eventsPerStream, OneEventCollection newData, OneEventCollection oldData, AgentInstanceContext agentInstanceContext) {
        Integer result;
        EventBean theEvent = this.insertHelper.process(eventsPerStream, true, true, agentInstanceContext);
        if (this.insertIntoTable != null) {
            TableInstance tableInstance = this.insertIntoTable.getTableInstance(agentInstanceContext.getAgentInstanceId());
            tableInstance.addEventUnadorned(theEvent);
            return;
        }
        if (!this.route) {
            newData.add(theEvent);
            return;
        }
        if (this.audit) {
            agentInstanceContext.getAuditProvider().insert(theEvent, agentInstanceContext);
        }
        int precedence = 0;
        if (this.eventPrecedence != null && (result = (Integer)this.eventPrecedence.evaluate(new EventBean[]{theEvent}, true, agentInstanceContext)) != null) {
            precedence = result;
        }
        agentInstanceContext.getInternalEventRouter().route(theEvent, agentInstanceContext, false, precedence);
    }

    @Override
    public void apply(EventBean matchingEvent, EventBean[] eventsPerStream, TableInstance tableStateInstance, OnExprViewTableChangeHandler changeHandlerAdded, OnExprViewTableChangeHandler changeHandlerRemoved, AgentInstanceContext agentInstanceContext) {
        EventBean theEvent = this.insertHelper.process(eventsPerStream, true, true, agentInstanceContext);
        if (!this.route) {
            AggregationRow aggs = tableStateInstance.getTable().getAggregationRowFactory().make();
            ((Object[])theEvent.getUnderlying())[0] = aggs;
            tableStateInstance.addEvent(theEvent);
            if (changeHandlerAdded != null) {
                changeHandlerAdded.add(theEvent, eventsPerStream, true, agentInstanceContext);
            }
            return;
        }
        if (this.insertIntoTable != null) {
            TableInstance tableInstance = this.insertIntoTable.getTableInstance(agentInstanceContext.getAgentInstanceId());
            tableInstance.addEventUnadorned(theEvent);
            return;
        }
        if (this.audit) {
            agentInstanceContext.getAuditProvider().insert(theEvent, agentInstanceContext);
        }
        int precedence = ExprNodeUtilityEvaluate.evaluateIntOptional(this.eventPrecedence, theEvent, 0, agentInstanceContext);
        agentInstanceContext.getInternalEventRouter().route(theEvent, agentInstanceContext, false, precedence);
    }

    @Override
    public String getName() {
        return this.route ? "insert-into" : "select";
    }
}

