/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.InsertIntoDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeAction;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionDelete;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionInsert;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeActionUpdate;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerMergeMatched;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementWildcard;
import com.espertech.esper.common.internal.compile.stage2.SelectClauseElementCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeActionDelForge;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeActionForge;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeActionIns;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeActionInsForge;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeActionUpdForge;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeHelper;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeMatch;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeMatchForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectClauseStreamCompiledSpec;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorFactory;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectExprProcessorForge;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectProcessorArgs;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyFactory;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperForge;
import com.espertech.esper.common.internal.epl.updatehelper.EventBeanUpdateHelperForgeFactory;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.util.UuidGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfraOnMergeHelperForge {
    private InfraOnMergeActionInsForge insertUnmatched;
    private List<InfraOnMergeMatchForge> matched = new ArrayList<InfraOnMergeMatchForge>();
    private List<InfraOnMergeMatchForge> unmatched = new ArrayList<InfraOnMergeMatchForge>();
    private boolean requiresTableWriteLock;

    public InfraOnMergeHelperForge(OnTriggerMergeDesc onTriggerDesc, EventType triggeringEventType, String triggeringStreamName, String infraName, EventTypeSPI infraEventType, StatementRawInfo statementRawInfo, StatementCompileTimeServices services, TableMetaData table) throws ExprValidationException {
        int count = 1;
        boolean hasDeleteAction = false;
        boolean hasInsertIntoTableAction = false;
        boolean hasUpdateAction = false;
        for (OnTriggerMergeMatched matchedItem : onTriggerDesc.getItems()) {
            ArrayList<InfraOnMergeActionForge> actions = new ArrayList<InfraOnMergeActionForge>();
            for (OnTriggerMergeAction item : matchedItem.getActions()) {
                try {
                    if (item instanceof OnTriggerMergeActionInsert) {
                        OnTriggerMergeActionInsert insertDesc = (OnTriggerMergeActionInsert)item;
                        InfraOnMergeActionInsForge forge = this.setupInsert(infraName, infraEventType, insertDesc, triggeringEventType, triggeringStreamName, statementRawInfo, services, table != null);
                        actions.add(forge);
                        hasInsertIntoTableAction = forge.getInsertIntoTable() != null;
                    } else if (item instanceof OnTriggerMergeActionUpdate) {
                        OnTriggerMergeActionUpdate updateDesc = (OnTriggerMergeActionUpdate)item;
                        EventBeanUpdateHelperForge updateHelper = EventBeanUpdateHelperForgeFactory.make(infraName, infraEventType, updateDesc.getAssignments(), onTriggerDesc.getOptionalAsName(), triggeringEventType, true, statementRawInfo.getStatementName(), services.getEventTypeAvroHandler());
                        ExprNode filterEval = updateDesc.getOptionalWhereClause();
                        if (table != null) {
                            TableUpdateStrategyFactory.validateTableUpdateOnMerge(table, updateHelper.getUpdateItemsPropertyNames());
                        }
                        InfraOnMergeActionUpdForge forge = new InfraOnMergeActionUpdForge(filterEval, updateHelper, table);
                        actions.add(forge);
                        hasUpdateAction = true;
                    } else if (item instanceof OnTriggerMergeActionDelete) {
                        OnTriggerMergeActionDelete deleteDesc = (OnTriggerMergeActionDelete)item;
                        ExprNode filterEval = deleteDesc.getOptionalWhereClause();
                        actions.add(new InfraOnMergeActionDelForge(filterEval));
                        hasDeleteAction = true;
                    } else {
                        throw new IllegalArgumentException("Invalid type of merge item '" + item.getClass() + "'");
                    }
                    ++count;
                }
                catch (EPException | ExprValidationException ex) {
                    boolean isNot = item instanceof OnTriggerMergeActionInsert;
                    String message = "Validation failed in when-" + (isNot ? "not-" : "") + "matched (clause " + count + "): " + ex.getMessage();
                    throw new ExprValidationException(message, ex);
                }
            }
            if (matchedItem.isMatchedUnmatched()) {
                this.matched.add(new InfraOnMergeMatchForge(matchedItem.getOptionalMatchCond(), actions));
                continue;
            }
            this.unmatched.add(new InfraOnMergeMatchForge(matchedItem.getOptionalMatchCond(), actions));
        }
        if (onTriggerDesc.getOptionalInsertNoMatch() != null) {
            this.insertUnmatched = this.setupInsert(infraName, infraEventType, onTriggerDesc.getOptionalInsertNoMatch(), triggeringEventType, triggeringStreamName, statementRawInfo, services, table != null);
        }
        this.requiresTableWriteLock = hasDeleteAction || hasInsertIntoTableAction || hasUpdateAction;
    }

    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(InfraOnMergeHelper.EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(InfraOnMergeActionIns.EPTYPE, "insertUnmatched", this.insertUnmatched == null ? CodegenExpressionBuilder.constantNull() : this.insertUnmatched.make(method, symbols, classScope)).declareVar(EPTypePremade.LIST.getEPType(), "matched", this.makeList(this.matched, method, symbols, classScope)).declareVar(EPTypePremade.LIST.getEPType(), "unmatched", this.makeList(this.unmatched, method, symbols, classScope)).methodReturn(CodegenExpressionBuilder.newInstance(InfraOnMergeHelper.EPTYPE, CodegenExpressionBuilder.ref("insertUnmatched"), CodegenExpressionBuilder.ref("matched"), CodegenExpressionBuilder.ref("unmatched"), CodegenExpressionBuilder.constant(this.requiresTableWriteLock)));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private CodegenExpression makeList(List<InfraOnMergeMatchForge> items, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(EPTypePremade.LIST.getEPType(), this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(EPTypeClassParameterized.from(List.class, InfraOnMergeMatch.class), "list", CodegenExpressionBuilder.newInstance(EPTypePremade.ARRAYLIST.getEPType(), CodegenExpressionBuilder.constant(items.size())));
        for (InfraOnMergeMatchForge item : items) {
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("list"), "add", item.make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("list"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    private InfraOnMergeActionInsForge setupInsert(String infraName, EventType infraType, OnTriggerMergeActionInsert desc, EventType triggeringEventType, String triggeringStreamName, StatementRawInfo statementRawInfo, StatementCompileTimeServices services, boolean isTable) throws ExprValidationException {
        String streamName = desc.getOptionalStreamName() != null ? desc.getOptionalStreamName() : infraName;
        InsertIntoDesc insertIntoDesc = InsertIntoDesc.fromColumns(streamName, desc.getColumns());
        if (triggeringStreamName == null) {
            triggeringStreamName = UuidGenerator.generate();
        }
        List<SelectClauseElementCompiled> selectNoWildcard = InfraOnMergeHelperForge.compileSelectNoWildcard(triggeringStreamName, desc.getSelectClauseCompiled());
        EventTypeMetadata eventTypeMetadata = new EventTypeMetadata("merge_infra_insert", statementRawInfo.getModuleName(), EventTypeTypeClass.STREAM, EventTypeApplicationType.MAP, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        MapEventType dummyTypeNoProperties = BaseNestableEventUtil.makeMapTypeCompileTime(eventTypeMetadata, Collections.emptyMap(), null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        EventType[] eventTypes = new EventType[]{dummyTypeNoProperties, triggeringEventType};
        String[] streamNames = new String[]{UuidGenerator.generate(), triggeringStreamName};
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventTypes, streamNames, new boolean[eventTypes.length], false, false);
        SelectClauseElementCompiled[] selectClause = selectNoWildcard.toArray(new SelectClauseElementCompiled[selectNoWildcard.size()]);
        SelectProcessorArgs args = new SelectProcessorArgs(selectClause, null, false, null, null, streamTypeService, false, statementRawInfo.getAnnotations(), statementRawInfo, services);
        if (isTable && streamName.equals(infraName)) {
            args.setOptionalInsertIntoEventType(infraType);
        }
        SelectExprProcessorForge insertHelperForge = SelectExprProcessorFactory.getProcessor(args, insertIntoDesc, false).getForge();
        ExprNode filterEval = desc.getOptionalWhereClause();
        boolean route = !streamName.equals(infraName);
        boolean audit = AuditEnum.INSERT.getAudit(statementRawInfo.getAnnotations()) != null;
        TableMetaData insertIntoTable = services.getTableCompileTimeResolver().resolve(insertIntoDesc.getEventTypeName());
        ExprNode eventPrecedence = null;
        if (desc.getEventPrecedence() != null) {
            eventPrecedence = EPLValidationUtil.validateEventPrecedence(insertIntoTable != null, desc.getEventPrecedence(), insertHelperForge.getResultEventType(), statementRawInfo, services);
        }
        return new InfraOnMergeActionInsForge(filterEval, insertHelperForge, insertIntoTable, audit, route, eventPrecedence);
    }

    public static List<SelectClauseElementCompiled> compileSelectNoWildcard(String triggeringStreamName, List<SelectClauseElementCompiled> selectClause) {
        ArrayList<SelectClauseElementCompiled> selectNoWildcard = new ArrayList<SelectClauseElementCompiled>();
        for (SelectClauseElementCompiled element : selectClause) {
            if (!(element instanceof SelectClauseElementWildcard)) {
                selectNoWildcard.add(element);
                continue;
            }
            SelectClauseStreamCompiledSpec streamSelect = new SelectClauseStreamCompiledSpec(triggeringStreamName, null);
            streamSelect.setStreamNumber(1);
            selectNoWildcard.add(streamSelect);
        }
        return selectNoWildcard;
    }
}

