/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.ontrigger;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.ontrigger.InfraOnMergeAction;
import com.espertech.esper.common.internal.epl.ontrigger.OnExprViewTableChangeHandler;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import java.util.List;

public class InfraOnMergeMatch {
    public static final EPTypeClass EPTYPE = new EPTypeClass(InfraOnMergeMatch.class);
    private ExprEvaluator optionalCond;
    private List<InfraOnMergeAction> actions;

    public InfraOnMergeMatch(ExprEvaluator optionalCond, List<InfraOnMergeAction> actions) {
        this.optionalCond = optionalCond;
        this.actions = actions;
    }

    public boolean isApplies(EventBean[] eventsPerStream, ExprEvaluatorContext context) {
        if (this.optionalCond == null) {
            return true;
        }
        Object result = this.optionalCond.evaluate(eventsPerStream, true, context);
        return result != null && (Boolean)result != false;
    }

    public void applyNamedWindow(EventBean matchingEvent, EventBean[] eventsPerStream, OneEventCollection newData, OneEventCollection oldData, AgentInstanceContext agentInstanceContext) {
        InstrumentationCommon instrumentationCommon = agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qInfraMergeWhenThenActions(this.actions.size());
        int count = -1;
        for (InfraOnMergeAction action : this.actions) {
            instrumentationCommon.qInfraMergeWhenThenActionItem(++count, action.getName());
            boolean applies = action.isApplies(eventsPerStream, agentInstanceContext);
            if (applies) {
                action.apply(matchingEvent, eventsPerStream, newData, oldData, agentInstanceContext);
            }
            instrumentationCommon.aInfraMergeWhenThenActionItem(applies);
        }
        instrumentationCommon.aInfraMergeWhenThenActions();
    }

    public void applyTable(EventBean matchingEvent, EventBean[] eventsPerStream, TableInstance stateInstance, OnExprViewTableChangeHandler changeHandlerAdded, OnExprViewTableChangeHandler changeHandlerRemoved, AgentInstanceContext agentInstanceContext) {
        InstrumentationCommon instrumentationCommon = agentInstanceContext.getInstrumentationProvider();
        instrumentationCommon.qInfraMergeWhenThenActions(this.actions.size());
        int count = -1;
        for (InfraOnMergeAction action : this.actions) {
            instrumentationCommon.qInfraMergeWhenThenActionItem(++count, action.getName());
            boolean applies = action.isApplies(eventsPerStream, agentInstanceContext);
            if (applies) {
                action.apply(matchingEvent, eventsPerStream, stateInstance, changeHandlerAdded, changeHandlerRemoved, agentInstanceContext);
            }
            instrumentationCommon.aInfraMergeWhenThenActionItem(applies);
        }
        instrumentationCommon.aInfraMergeWhenThenActions();
    }
}

