/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.util.StateMgmtSetting;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.StatementResultService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewAfterState;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorStraightOutputFirstHelper;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.metrics.audit.AuditPath;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessViewConditionFirst
extends OutputProcessViewBaseWAfter {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private List<UniformPair<EventBean[]>> viewEventsList = new ArrayList<UniformPair<EventBean[]>>();
    private List<UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>> joinEventsSet = new ArrayList<UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>>();
    private ResultSetProcessorStraightOutputFirstHelper witnessedFirstHelper;
    private static final Logger log = LoggerFactory.getLogger(OutputProcessViewConditionFirst.class);

    public OutputProcessViewConditionFirst(ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext, StateMgmtSetting stateMgmtSetting) {
        super(agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().instantiateOutputCondition(agentInstanceContext, outputCallback);
        this.witnessedFirstHelper = agentInstanceContext.getResultSetProcessorHelperFactory().makeRSStraightOutputFirst(agentInstanceContext, stateMgmtSetting);
    }

    @Override
    public int getNumChangesetRows() {
        return Math.max(this.viewEventsList.size(), this.joinEventsSet.size());
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return this.outputCondition;
    }

    @Override
    public OutputProcessViewAfterState getOptionalAfterConditionState() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (!super.checkAfterCondition(newData, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        if (!this.witnessedFirstHelper.getWitnessedFirst()) {
            StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
            boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
            this.viewEventsList.add(new UniformPair<EventBean[]>(newData, oldData));
            UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedView(this.viewEventsList, isGenerateSynthetic);
            this.viewEventsList.clear();
            if (!this.hasRelevantResults(newOldEvents)) {
                return;
            }
            this.witnessedFirstHelper.setWitnessedFirst(true);
            if (this.parent.isDistinct()) {
                newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
                newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
            }
            boolean isGenerateNatural = statementResultService.isMakeNatural();
            if (!isGenerateSynthetic && !isGenerateNatural) {
                if (AuditPath.isAuditEnabled) {
                    OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
                }
                return;
            }
            this.output(true, newOldEvents);
        } else {
            this.viewEventsList.add(new UniformPair<EventBean[]>(newData, oldData));
            this.resultSetProcessor.processOutputLimitedView(this.viewEventsList, false);
            this.viewEventsList.clear();
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        if (!super.checkAfterCondition(newEvents, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        if (!this.witnessedFirstHelper.getWitnessedFirst()) {
            StatementResultService statementResultService = this.agentInstanceContext.getStatementResultService();
            OutputProcessViewConditionFirst.addToChangeSet(this.joinEventsSet, newEvents, oldEvents);
            boolean isGenerateSynthetic = statementResultService.isMakeSynthetic();
            UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processOutputLimitedJoin(this.joinEventsSet, isGenerateSynthetic);
            this.joinEventsSet.clear();
            if (!this.hasRelevantResults(newOldEvents)) {
                return;
            }
            this.witnessedFirstHelper.setWitnessedFirst(true);
            if (this.parent.isDistinct()) {
                newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
                newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
            }
            boolean isGenerateNatural = statementResultService.isMakeNatural();
            if (!isGenerateSynthetic && !isGenerateNatural) {
                if (AuditPath.isAuditEnabled) {
                    OutputStrategyUtil.indicateEarlyReturn(this.agentInstanceContext.getStatementContext(), newOldEvents);
                }
                return;
            }
            this.output(true, newOldEvents);
        } else {
            OutputProcessViewConditionFirst.addToChangeSet(this.joinEventsSet, newEvents, oldEvents);
            this.resultSetProcessor.processOutputLimitedJoin(this.joinEventsSet, false);
            this.joinEventsSet.clear();
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingView");
        }
        this.witnessedFirstHelper.setWitnessedFirst(false);
    }

    protected void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.child != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.child);
        }
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingJoin");
        }
        this.witnessedFirstHelper.setWitnessedFirst(false);
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionFirst.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionFirst.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct(), this.parent.getDistinctKeyGetter());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        super.stop(services);
        this.outputCondition.stopOutputCondition();
        this.witnessedFirstHelper.destroy();
    }

    private boolean hasRelevantResults(UniformPair<EventBean[]> newOldEvents) {
        if (newOldEvents == null) {
            return false;
        }
        return !(this.parent.getSelectClauseStreamSelectorEnum() == SelectClauseStreamSelectorEnum.ISTREAM_ONLY ? newOldEvents.getFirst() == null : (this.parent.getSelectClauseStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH ? newOldEvents.getFirst() == null && newOldEvents.getSecond() == null : newOldEvents.getSecond() == null));
    }

    private static void addToChangeSet(List<UniformPair<Set<MultiKeyArrayOfKeys<EventBean>>>> joinEventsSet, Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents) {
        LinkedHashSet<Object> copyNew = newEvents != null ? new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>(newEvents) : new LinkedHashSet();
        LinkedHashSet<Object> copyOld = oldEvents != null ? new LinkedHashSet<MultiKeyArrayOfKeys<EventBean>>(oldEvents) : new LinkedHashSet();
        joinEventsSet.add(new UniformPair(copyNew, copyOld));
    }
}

