/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.output.view;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.output.condition.OutputCallback;
import com.espertech.esper.common.internal.epl.output.condition.OutputCondition;
import com.espertech.esper.common.internal.epl.output.core.OutputStrategyUtil;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewAfterState;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewBaseWAfter;
import com.espertech.esper.common.internal.epl.output.view.OutputProcessViewConditionFactory;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputProcessViewConditionLastAllUnord
extends OutputProcessViewBaseWAfter {
    private final OutputProcessViewConditionFactory parent;
    private final OutputCondition outputCondition;
    private static final Logger log = LoggerFactory.getLogger(OutputProcessViewConditionLastAllUnord.class);

    public OutputProcessViewConditionLastAllUnord(ResultSetProcessor resultSetProcessor, Long afterConditionTime, Integer afterConditionNumberOfEvents, boolean afterConditionSatisfied, OutputProcessViewConditionFactory parent, AgentInstanceContext agentInstanceContext) {
        super(agentInstanceContext, resultSetProcessor, afterConditionTime, afterConditionNumberOfEvents, afterConditionSatisfied);
        this.parent = parent;
        OutputCallback outputCallback = this.getCallbackToLocal(parent.getStreamCount());
        this.outputCondition = parent.getOutputConditionFactory().instantiateOutputCondition(agentInstanceContext, outputCallback);
    }

    @Override
    public int getNumChangesetRows() {
        return 0;
    }

    @Override
    public OutputCondition getOptionalOutputCondition() {
        return this.outputCondition;
    }

    @Override
    public OutputProcessViewAfterState getOptionalAfterConditionState() {
        return null;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        boolean isGenerateSynthetic = this.agentInstanceContext.getStatementResultService().isMakeSynthetic();
        this.resultSetProcessor.processOutputLimitedLastAllNonBufferedView(newData, oldData, isGenerateSynthetic);
        if (!super.checkAfterCondition(newData, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        int newDataLength = 0;
        int oldDataLength = 0;
        if (newData != null) {
            newDataLength = newData.length;
        }
        if (oldData != null) {
            oldDataLength = oldData.length;
        }
        this.outputCondition.updateOutputCondition(newDataLength, oldDataLength);
    }

    @Override
    public void process(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        boolean isGenerateSynthetic = this.agentInstanceContext.getStatementResultService().isMakeSynthetic();
        this.resultSetProcessor.processOutputLimitedLastAllNonBufferedJoin(newEvents, oldEvents, isGenerateSynthetic);
        if (!super.checkAfterCondition(newEvents, this.agentInstanceContext.getStatementContext())) {
            return;
        }
        int newEventsSize = 0;
        if (newEvents != null) {
            newEventsSize = newEvents.size();
        }
        int oldEventsSize = 0;
        if (oldEvents != null) {
            oldEventsSize = oldEvents.size();
        }
        this.outputCondition.updateOutputCondition(newEventsSize, oldEventsSize);
    }

    protected void continueOutputProcessingView(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingView");
        }
        boolean isGenerateSynthetic = this.agentInstanceContext.getStatementResultService().isMakeSynthetic();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.continueOutputLimitedLastAllNonBufferedView(isGenerateSynthetic);
        this.continueOutputProcessingViewAndJoin(doOutput, forceUpdate, newOldEvents);
    }

    protected void output(boolean forceUpdate, UniformPair<EventBean[]> results) {
        if (this.child != null) {
            OutputStrategyUtil.output(forceUpdate, results, this.child);
        }
    }

    protected void continueOutputProcessingJoin(boolean doOutput, boolean forceUpdate) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".continueOutputProcessingJoin");
        }
        boolean isGenerateSynthetic = this.agentInstanceContext.getStatementResultService().isMakeSynthetic();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.continueOutputLimitedLastAllNonBufferedJoin(isGenerateSynthetic);
        this.continueOutputProcessingViewAndJoin(doOutput, forceUpdate, newOldEvents);
    }

    private OutputCallback getCallbackToLocal(int streamCount) {
        if (streamCount == 1) {
            return new OutputCallback(){

                @Override
                public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                    OutputProcessViewConditionLastAllUnord.this.continueOutputProcessingView(doOutput, forceUpdate);
                }
            };
        }
        return new OutputCallback(){

            @Override
            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputProcessViewConditionLastAllUnord.this.continueOutputProcessingJoin(doOutput, forceUpdate);
            }
        };
    }

    @Override
    public Iterator<EventBean> iterator() {
        return OutputStrategyUtil.getIterator(this.joinExecutionStrategy, this.resultSetProcessor, this.parentView, this.parent.isDistinct(), this.parent.getDistinctKeyGetter());
    }

    @Override
    public void terminated() {
        if (this.parent.isTerminable()) {
            this.outputCondition.terminated();
        }
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        super.stop(services);
        this.outputCondition.stopOutputCondition();
    }

    private void continueOutputProcessingViewAndJoin(boolean doOutput, boolean forceUpdate, UniformPair<EventBean[]> newOldEvents) {
        if (this.parent.isDistinct() && newOldEvents != null) {
            newOldEvents.setFirst(EventBeanUtility.getDistinctByProp(newOldEvents.getFirst(), this.parent.getDistinctKeyGetter()));
            newOldEvents.setSecond(EventBeanUtility.getDistinctByProp(newOldEvents.getSecond(), this.parent.getDistinctKeyGetter()));
        }
        if (doOutput) {
            this.output(forceUpdate, newOldEvents);
        }
    }
}

