/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.pattern.core.PatternContext;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterConsumptionHandler;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filtersvc.FilterService;
import java.util.function.Function;

public class PatternAgentInstanceContext {
    public static final EPTypeClass EPTYPE = new EPTypeClass(PatternAgentInstanceContext.class);
    protected final PatternContext patternContext;
    protected final AgentInstanceContext agentInstanceContext;
    protected final EvalFilterConsumptionHandler consumptionHandler;
    protected final Function<FilterSpecActivatable, FilterValueSetParam[][]> contextAddendumFunction;

    public PatternAgentInstanceContext(PatternContext patternContext, AgentInstanceContext agentInstanceContext, boolean hasConsumingFilter, Function<FilterSpecActivatable, FilterValueSetParam[][]> contextAddendumFunction) {
        this.patternContext = patternContext;
        this.agentInstanceContext = agentInstanceContext;
        this.contextAddendumFunction = contextAddendumFunction;
        this.consumptionHandler = hasConsumingFilter ? new EvalFilterConsumptionHandler() : null;
    }

    public PatternContext getPatternContext() {
        return this.patternContext;
    }

    public EvalFilterConsumptionHandler getConsumptionHandler() {
        return this.consumptionHandler;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public StatementContext getStatementContext() {
        return this.agentInstanceContext.getStatementContext();
    }

    public String getStatementName() {
        return this.agentInstanceContext.getStatementName();
    }

    public FilterService getFilterService() {
        return this.getStatementContext().getFilterService();
    }

    public long getTime() {
        return this.agentInstanceContext.getSchedulingService().getTime();
    }

    public FilterValueSetParam[][] getFilterAddendumForContextPath(FilterSpecActivatable filterSpec) {
        return this.contextAddendumFunction == null ? null : this.contextAddendumFunction.apply(filterSpec);
    }
}

