/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternExpressionUtil {
    private static final Logger log = LoggerFactory.getLogger(PatternExpressionUtil.class);

    public static void toPrecedenceFreeEPL(StringWriter writer, String delimiterText, List<EvalForgeNode> childNodes, PatternExpressionPrecedenceEnum precedence) {
        Object delimiter = "";
        for (EvalForgeNode child : childNodes) {
            writer.append((CharSequence)delimiter);
            child.toEPL(writer, precedence);
            delimiter = " " + delimiterText + " ";
        }
    }

    public static Object getKeys(MatchedEventMap matchEvent, MatchedEventConvertor convertor, ExprEvaluator expression, AgentInstanceContext agentInstanceContext) {
        EventBean[] eventsPerStream = convertor.convert(matchEvent);
        return expression.evaluate(eventsPerStream, true, agentInstanceContext);
    }

    public static Object evaluateChecked(String objectName, ExprEvaluator evaluator, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext) throws EPException {
        try {
            return evaluator.evaluate(eventsPerStream, true, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            throw PatternExpressionUtil.handleRuntimeEx(ex, objectName);
        }
    }

    public static EPException handleRuntimeEx(RuntimeException ex, String objectName) {
        String message = objectName + " failed to evaluate expression";
        if (ex.getMessage() != null) {
            message = message + ": " + ex.getMessage();
        }
        log.error(message, (Throwable)ex);
        throw new EPException(message);
    }
}

