/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.filter;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.FilterSpecRaw;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.filter.EvalFilterFactoryNode;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;

public class EvalFilterForgeNode
extends EvalForgeNodeBase {
    private final FilterSpecRaw rawFilterSpec;
    private final String eventAsName;
    private transient FilterSpecCompiled filterSpec;
    private final Integer consumptionLevel;
    private int eventAsTagNumber = -1;

    public EvalFilterForgeNode(boolean attachPatternText, FilterSpecRaw filterSpecification, String eventAsName, Integer consumptionLevel) {
        super(attachPatternText);
        this.rawFilterSpec = filterSpecification;
        this.eventAsName = eventAsName;
        this.consumptionLevel = consumptionLevel;
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    public final FilterSpecCompiled getFilterSpecCompiled() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpecCompiled filterSpec) {
        this.filterSpec = filterSpec;
    }

    public final String getEventAsName() {
        return this.eventAsName;
    }

    public Integer getConsumptionLevel() {
        return this.consumptionLevel;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterNode rawFilterSpec=" + this.rawFilterSpec);
        buffer.append(" filterSpec=" + this.filterSpec);
        buffer.append(" eventAsName=" + this.eventAsName);
        return buffer.toString();
    }

    public boolean isFilterChildNonQuitting() {
        return false;
    }

    public int getEventAsTagNumber() {
        return this.eventAsTagNumber;
    }

    public void setEventAsTagNumber(int eventAsTagNumber) {
        this.eventAsTagNumber = eventAsTagNumber;
    }

    public boolean isStateful() {
        return false;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.getEventAsName() != null) {
            writer.append(this.getEventAsName());
            writer.append("=");
        }
        writer.append(this.rawFilterSpec.getEventTypeName());
        if (this.rawFilterSpec.getFilterExpressions() != null && this.rawFilterSpec.getFilterExpressions().size() > 0) {
            writer.append("(");
            ExprNodeUtilityPrint.toExpressionStringParameterList(this.rawFilterSpec.getFilterExpressions(), writer);
            writer.append(")");
        }
        if (this.consumptionLevel != null) {
            writer.append("@consume");
            if (this.consumptionLevel != 1) {
                writer.append("(");
                writer.append(Integer.toString(this.consumptionLevel));
                writer.append(")");
            }
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.ATOM;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalFilterFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "filter";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setFilterSpec", CodegenExpressionBuilder.localMethod(this.filterSpec.makeCodegen(method, symbols, classScope), new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setEventAsName", CodegenExpressionBuilder.constant(this.eventAsName)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setConsumptionLevel", CodegenExpressionBuilder.constant(this.consumptionLevel)).exprDotMethod(CodegenExpressionBuilder.ref("node"), "setEventAsTagNumber", CodegenExpressionBuilder.constant(this.eventAsTagNumber));
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
        filters.add(new FilterSpecTracked(callbackAttribution.apply(this.factoryNodeId), this.filterSpec));
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_FILTER;
    }
}

