/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.followedby;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionUtil;
import com.espertech.esper.common.internal.epl.pattern.followedby.EvalFollowedByFactoryNode;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;

public class EvalFollowedByForgeNode
extends EvalForgeNodeBase {
    private List<ExprNode> optionalMaxExpressions;

    public EvalFollowedByForgeNode(boolean attachPatternText, List<ExprNode> optionalMaxExpressions) {
        super(attachPatternText);
        this.optionalMaxExpressions = optionalMaxExpressions;
    }

    public List<ExprNode> getOptionalMaxExpressions() {
        return this.optionalMaxExpressions;
    }

    public void setOptionalMaxExpressions(List<ExprNode> optionalMaxExpressions) {
        this.optionalMaxExpressions = optionalMaxExpressions;
    }

    public final String toString() {
        return "EvalFollowedByNode children=" + this.getChildNodes().size();
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.optionalMaxExpressions == null || this.optionalMaxExpressions.isEmpty()) {
            PatternExpressionUtil.toPrecedenceFreeEPL(writer, "->", this.getChildNodes(), this.getPrecedence());
        } else {
            this.getChildNodes().get(0).toEPL(writer, PatternExpressionPrecedenceEnum.MINIMUM);
            for (int i = 1; i < this.getChildNodes().size(); ++i) {
                ExprNode optionalMaxExpression = null;
                if (this.optionalMaxExpressions.size() > i - 1) {
                    optionalMaxExpression = this.optionalMaxExpressions.get(i - 1);
                }
                if (optionalMaxExpression == null) {
                    writer.append(" -> ");
                } else {
                    writer.append(" -[");
                    writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(optionalMaxExpression));
                    writer.append("]> ");
                }
                this.getChildNodes().get(i).toEPL(writer, PatternExpressionPrecedenceEnum.MINIMUM);
            }
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.FOLLOWEDBY;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalFollowedByFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "followedby";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        int i;
        method.getBlock().declareVar(EvalFactoryNode.EPTYPEARRAY, "children", CodegenExpressionBuilder.newArrayByLength(EvalFactoryNode.EPTYPE, CodegenExpressionBuilder.constant(this.getChildNodes().size())));
        for (i = 0; i < this.getChildNodes().size(); ++i) {
            method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("children"), CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(this.getChildNodes().get(i).makeCodegen(method, symbols, classScope), new CodegenExpression[0]));
        }
        method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setChildren", CodegenExpressionBuilder.ref("children")).expression(CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("addReadyCallback", CodegenExpressionBuilder.ref("node")));
        if (this.optionalMaxExpressions != null && !this.optionalMaxExpressions.isEmpty()) {
            method.getBlock().declareVar(ExprEvaluator.EPTYPEARRAY, "evals", CodegenExpressionBuilder.newArrayByLength(ExprEvaluator.EPTYPE, CodegenExpressionBuilder.constant(this.getChildNodes().size() - 1)));
            for (i = 0; i < this.getChildNodes().size() - 1; ++i) {
                ExprNode optionalMaxExpression;
                if (this.optionalMaxExpressions.size() <= i || (optionalMaxExpression = this.optionalMaxExpressions.get(i)) == null) continue;
                method.getBlock().assignArrayElement("evals", CodegenExpressionBuilder.constant(i), (CodegenExpression)ExprNodeUtilityCodegen.codegenEvaluatorNoCoerce(optionalMaxExpression.getForge(), method, this.getClass(), classScope));
            }
            method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("node"), "setMaxPerChildEvals", CodegenExpressionBuilder.ref("evals"));
        }
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_FOLLOWEDBY;
    }
}

