/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.matchuntil;

import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.util.CallbackAttribution;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.pattern.core.EvalFactoryNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalForgeNodeBase;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionPrecedenceEnum;
import com.espertech.esper.common.internal.epl.pattern.matchuntil.EvalMatchUntilFactoryNode;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Function;

public class EvalMatchUntilForgeNode
extends EvalForgeNodeBase {
    private ExprNode lowerBounds;
    private ExprNode upperBounds;
    private ExprNode singleBound;
    private MatchedEventConvertorForge convertor;
    private int[] tagsArrayed;

    public EvalMatchUntilForgeNode(boolean attachPatternText, ExprNode lowerBounds, ExprNode upperBounds, ExprNode singleBound) {
        super(attachPatternText);
        if (singleBound != null && (lowerBounds != null || upperBounds != null)) {
            throw new IllegalArgumentException("Invalid bounds, specify either single bound or range bounds");
        }
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
        this.singleBound = singleBound;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return EvalMatchUntilFactoryNode.EPTYPE;
    }

    @Override
    protected String nameOfFactory() {
        return "matchUntil";
    }

    @Override
    protected void inlineCodegen(CodegenMethod method, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().declareVar(EvalFactoryNode.EPTYPEARRAY, "children", CodegenExpressionBuilder.newArrayByLength(EvalFactoryNode.EPTYPE, CodegenExpressionBuilder.constant(this.getChildNodes().size())));
        for (int i = 0; i < this.getChildNodes().size(); ++i) {
            method.getBlock().assignArrayElement(CodegenExpressionBuilder.ref("children"), CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.localMethod(this.getChildNodes().get(i).makeCodegen(method, symbols, classScope), new CodegenExpression[0]));
        }
        CodegenExpressionRef node = CodegenExpressionBuilder.ref("node");
        CodegenExpression converterExpression = !(this.lowerBounds != null && !this.lowerBounds.getForge().getForgeConstantType().isCompileTimeConstant() || this.upperBounds != null && !this.upperBounds.getForge().getForgeConstantType().isCompileTimeConstant() || this.singleBound != null && !this.singleBound.getForge().getForgeConstantType().isCompileTimeConstant()) ? CodegenExpressionBuilder.constantNull() : this.convertor.makeAnonymous(method, classScope);
        method.getBlock().exprDotMethod(node, "setChildren", CodegenExpressionBuilder.ref("children")).exprDotMethod(node, "setLowerBounds", this.lowerBounds == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.lowerBounds.getForge(), method, this.getClass(), classScope)).exprDotMethod(node, "setUpperBounds", this.upperBounds == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.upperBounds.getForge(), method, this.getClass(), classScope)).exprDotMethod(node, "setSingleBound", this.singleBound == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.singleBound.getForge(), method, this.getClass(), classScope)).exprDotMethod(node, "setTagsArrayed", CodegenExpressionBuilder.constant(this.tagsArrayed)).exprDotMethod(node, "setOptionalConvertor", converterExpression);
    }

    @Override
    public void collectSelfFilterAndSchedule(Function<Short, CallbackAttribution> callbackAttribution, List<FilterSpecTracked> filters, List<ScheduleHandleTracked> schedules) {
    }

    public int[] getTagsArrayed() {
        return this.tagsArrayed;
    }

    public void setConvertor(MatchedEventConvertorForge convertor) {
        this.convertor = convertor;
    }

    public ExprNode getLowerBounds() {
        return this.lowerBounds;
    }

    public ExprNode getUpperBounds() {
        return this.upperBounds;
    }

    public ExprNode getSingleBound() {
        return this.singleBound;
    }

    public void setLowerBounds(ExprNode lowerBounds) {
        this.lowerBounds = lowerBounds;
    }

    public void setUpperBounds(ExprNode upperBounds) {
        this.upperBounds = upperBounds;
    }

    public void setSingleBound(ExprNode singleBound) {
        this.singleBound = singleBound;
    }

    public void setTagsArrayedSet(int[] tagsArrayedSet) {
        this.tagsArrayed = tagsArrayedSet;
    }

    public MatchedEventConvertorForge getConvertor() {
        return this.convertor;
    }

    public final String toString() {
        return "EvalMatchUntilNode children=" + this.getChildNodes().size();
    }

    public boolean isFilterChildNonQuitting() {
        return true;
    }

    public boolean isStateful() {
        return true;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        if (this.singleBound != null) {
            writer.append("[");
            writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.singleBound));
            writer.append("] ");
        } else if (this.lowerBounds != null || this.upperBounds != null) {
            writer.append("[");
            if (this.lowerBounds != null) {
                writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.lowerBounds));
            }
            writer.append(":");
            if (this.upperBounds != null) {
                writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.upperBounds));
            }
            writer.append("] ");
        }
        this.getChildNodes().get(0).toEPL(writer, this.getPrecedence());
        if (this.getChildNodes().size() > 1) {
            writer.append(" until ");
            this.getChildNodes().get(1).toEPL(writer, this.getPrecedence());
        }
    }

    @Override
    public PatternExpressionPrecedenceEnum getPrecedence() {
        return PatternExpressionPrecedenceEnum.REPEAT_UNTIL;
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.PATTERN_MATCHUNTIL;
    }
}

