/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.matchuntil;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.core.PatternConsumptionUtil;
import com.espertech.esper.common.internal.epl.pattern.matchuntil.EvalMatchUntilNode;
import com.espertech.esper.common.internal.epl.pattern.matchuntil.EvalMatchUntilStateBounds;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class EvalMatchUntilStateNode
extends EvalStateNode
implements Evaluator {
    protected final EvalMatchUntilNode evalMatchUntilNode;
    protected MatchedEventMap beginState;
    protected final ArrayList<EventBean>[] matchedEventArrays;
    protected EvalStateNode stateMatcher;
    protected EvalStateNode stateUntil;
    protected int numMatches;
    protected Integer lowerbounds;
    protected Integer upperbounds;

    public EvalMatchUntilStateNode(Evaluator parentNode, EvalMatchUntilNode evalMatchUntilNode) {
        super(parentNode);
        this.matchedEventArrays = new ArrayList[evalMatchUntilNode.getFactoryNode().getTagsArrayed().length];
        this.evalMatchUntilNode = evalMatchUntilNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        boolean quit = PatternConsumptionUtil.containsEvent(matchEvent, this.beginState);
        if (!quit) {
            for (ArrayList<EventBean> list : this.matchedEventArrays) {
                if (list == null) continue;
                for (EventBean event : list) {
                    if (!matchEvent.contains(event)) continue;
                    quit = true;
                    break;
                }
                if (quit) break;
            }
        }
        if (quit) {
            this.quit();
            AgentInstanceContext agentInstanceContext = this.evalMatchUntilNode.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().patternFalse(this.evalMatchUntilNode.getFactoryNode(), this, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        } else {
            if (this.stateMatcher != null) {
                this.stateMatcher.removeMatch(matchEvent);
            }
            if (this.stateUntil != null) {
                this.stateUntil.removeMatch(matchEvent);
            }
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalMatchUntilNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalMatchUntilNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternMatchUntilStart(this.evalMatchUntilNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
        this.beginState = beginState;
        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodeSub();
        this.stateMatcher = childMatcher.newState(this);
        if (this.evalMatchUntilNode.getChildNodeUntil() != null) {
            EvalNode childUntil = this.evalMatchUntilNode.getChildNodeUntil();
            this.stateUntil = childUntil.newState(this);
        }
        if (this.stateUntil != null) {
            this.stateUntil.start(beginState);
        }
        EvalMatchUntilStateBounds bounds = EvalMatchUntilStateBounds.initBounds(this.evalMatchUntilNode.getFactoryNode(), beginState, this.evalMatchUntilNode.getContext());
        this.lowerbounds = bounds.getLowerbounds();
        this.upperbounds = bounds.getUpperbounds();
        if (this.stateMatcher != null) {
            this.stateMatcher.start(beginState);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternMatchUntilStart();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalMatchUntilNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternMatchUntilEvaluateTrue(this.evalMatchUntilNode.factoryNode, matchEvent, fromNode == this.stateUntil);
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
            ++this.numMatches;
            int[] tags = this.evalMatchUntilNode.getFactoryNode().getTagsArrayed();
            for (int i = 0; i < tags.length; ++i) {
                Object theEvent = matchEvent.getMatchingEventAsObject(tags[i]);
                if (theEvent == null) continue;
                if (this.matchedEventArrays[i] == null) {
                    this.matchedEventArrays[i] = new ArrayList();
                }
                if (theEvent instanceof EventBean) {
                    this.matchedEventArrays[i].add((EventBean)theEvent);
                    continue;
                }
                EventBean[] arrayEvents = (EventBean[])theEvent;
                this.matchedEventArrays[i].addAll(Arrays.asList(arrayEvents));
            }
        }
        if (isQuitted) {
            if (isMatcher) {
                this.stateMatcher = null;
            } else {
                this.stateUntil = null;
            }
        }
        if (isMatcher) {
            if (this.isTightlyBound() && this.numMatches == this.lowerbounds) {
                this.quitInternal();
                consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
                agentInstanceContext.getAuditProvider().patternTrue(this.evalMatchUntilNode.getFactoryNode(), this, consolidated, true, agentInstanceContext);
                agentInstanceContext.getAuditProvider().patternInstance(false, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
                this.getParentEvaluator().evaluateTrue(consolidated, this, true, optionalTriggeringEvent);
            } else {
                boolean restart;
                boolean bl = restart = !this.isBounded() || this.upperbounds == null || this.upperbounds > this.numMatches;
                if (this.stateMatcher == null) {
                    if (restart) {
                        EvalNode childMatcher = this.evalMatchUntilNode.getChildNodeSub();
                        this.stateMatcher = childMatcher.newState(this);
                        this.stateMatcher.start(this.beginState);
                    }
                } else if (!restart) {
                    this.stateMatcher.quit();
                    this.stateMatcher = null;
                }
            }
        } else {
            this.quitInternal();
            consolidated = EvalMatchUntilStateNode.consolidate(matchEvent, this.matchedEventArrays, this.evalMatchUntilNode.getFactoryNode().getTagsArrayed());
            if (this.lowerbounds != null && this.numMatches < this.lowerbounds) {
                agentInstanceContext.getAuditProvider().patternFalse(this.evalMatchUntilNode.getFactoryNode(), this, agentInstanceContext);
                agentInstanceContext.getAuditProvider().patternInstance(false, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
                this.getParentEvaluator().evaluateFalse(this, true);
            } else {
                agentInstanceContext.getAuditProvider().patternTrue(this.evalMatchUntilNode.getFactoryNode(), this, consolidated, true, agentInstanceContext);
                agentInstanceContext.getAuditProvider().patternInstance(false, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
                this.getParentEvaluator().evaluateTrue(consolidated, this, true, optionalTriggeringEvent);
            }
        }
        agentInstanceContext.getInstrumentationProvider().aPatternMatchUntilEvaluateTrue(this.stateMatcher == null && this.stateUntil == null);
    }

    public static MatchedEventMap consolidate(MatchedEventMap beginState, ArrayList<EventBean>[] matchedEventList, int[] tagsArrayed) {
        if (tagsArrayed == null) {
            return beginState;
        }
        for (int i = 0; i < tagsArrayed.length; ++i) {
            if (matchedEventList[i] == null) continue;
            EventBean[] eventsForTag = matchedEventList[i].toArray(new EventBean[matchedEventList[i].size()]);
            beginState.add(tagsArrayed[i], eventsForTag);
        }
        return beginState;
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalMatchUntilNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternMatchUntilEvalFalse(this.evalMatchUntilNode.factoryNode, fromNode == this.stateUntil);
        boolean isMatcher = false;
        if (fromNode == this.stateMatcher) {
            isMatcher = true;
        }
        if (isMatcher) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        } else {
            this.stateUntil.quit();
            this.stateUntil = null;
        }
        agentInstanceContext.getAuditProvider().patternFalse(this.evalMatchUntilNode.getFactoryNode(), this, agentInstanceContext);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
        this.getParentEvaluator().evaluateFalse(this, true);
        agentInstanceContext.getInstrumentationProvider().aPatternMatchUntilEvalFalse();
    }

    @Override
    public final void quit() {
        if (this.stateMatcher == null && this.stateUntil == null) {
            return;
        }
        AgentInstanceContext agentInstanceContext = this.evalMatchUntilNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternMatchUntilQuit(this.evalMatchUntilNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalMatchUntilNode.factoryNode, agentInstanceContext);
        this.quitInternal();
        agentInstanceContext.getInstrumentationProvider().aPatternMatchUntilQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitMatchUntil(this.evalMatchUntilNode.getFactoryNode(), this, this.matchedEventArrays, this.beginState);
        if (this.stateMatcher != null) {
            this.stateMatcher.accept(visitor);
        }
        if (this.stateUntil != null) {
            this.stateUntil.accept(visitor);
        }
    }

    public final String toString() {
        return "EvalMatchUntilStateNode";
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return true;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    private boolean isTightlyBound() {
        return this.lowerbounds != null && this.upperbounds != null && this.upperbounds.equals(this.lowerbounds);
    }

    private boolean isBounded() {
        return this.lowerbounds != null || this.upperbounds != null;
    }

    private void quitInternal() {
        if (this.stateMatcher != null) {
            this.stateMatcher.quit();
            this.stateMatcher = null;
        }
        if (this.stateUntil != null) {
            this.stateUntil.quit();
            this.stateUntil = null;
        }
    }
}

