/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserver;
import com.espertech.esper.common.internal.epl.pattern.observer.EventObserverVisitor;
import com.espertech.esper.common.internal.epl.pattern.observer.ObserverEventEvaluator;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.schedule.ScheduleComputeHelper;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import com.espertech.esper.common.internal.schedule.SchedulingService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;

public class TimerAtObserver
implements EventObserver,
ScheduleHandleCallback {
    public static final String NAME_AUDITPROVIDER_SCHEDULE = "timer-at";
    private final ScheduleSpec scheduleSpec;
    private final long scheduleSlot;
    private final MatchedEventMap beginState;
    private final ObserverEventEvaluator observerEventEvaluator;
    private boolean isTimerActive = false;
    private EPStatementHandleCallbackSchedule scheduleHandle;

    public TimerAtObserver(ScheduleSpec scheduleSpec, MatchedEventMap beginState, ObserverEventEvaluator observerEventEvaluator) {
        this.scheduleSpec = scheduleSpec;
        this.beginState = beginState;
        this.observerEventEvaluator = observerEventEvaluator;
        this.scheduleSlot = observerEventEvaluator.getContext().getAgentInstanceContext().getScheduleBucket().allocateSlot();
    }

    @Override
    public MatchedEventMap getBeginState() {
        return this.beginState;
    }

    @Override
    public final void scheduledTrigger() {
        AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternObserverScheduledEval();
        agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        this.observerEventEvaluator.observerEvaluateTrue(this.beginState, true);
        this.isTimerActive = false;
        agentInstanceContext.getInstrumentationProvider().aPatternObserverScheduledEval();
    }

    @Override
    public void startObserve() {
        if (this.isTimerActive) {
            throw new IllegalStateException("Timer already active");
        }
        this.scheduleHandle = new EPStatementHandleCallbackSchedule(this.observerEventEvaluator.getContext().getAgentInstanceContext().getEpStatementAgentInstanceHandle(), this);
        AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
        SchedulingService schedulingService = agentInstanceContext.getSchedulingService();
        ClasspathImportServiceRuntime classpathImportService = agentInstanceContext.getClasspathImportServiceRuntime();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.scheduleSpec, schedulingService.getTime(), classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus());
        agentInstanceContext.getAuditProvider().scheduleAdd(nextScheduledTime, agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
        schedulingService.add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
        this.isTimerActive = true;
    }

    @Override
    public void stopObserve() {
        if (this.isTimerActive) {
            AgentInstanceContext agentInstanceContext = this.observerEventEvaluator.getContext().getAgentInstanceContext();
            agentInstanceContext.getAuditProvider().scheduleRemove(agentInstanceContext, this.scheduleHandle, ScheduleObjectType.pattern, NAME_AUDITPROVIDER_SCHEDULE);
            agentInstanceContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            this.isTimerActive = false;
            this.scheduleHandle = null;
        }
    }

    @Override
    public void accept(EventObserverVisitor visitor) {
        visitor.visitObserver(this.beginState, 2, this.scheduleSlot, this.scheduleSpec);
    }
}

