/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.observer;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.TimePeriod;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodEval;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertor;
import com.espertech.esper.common.internal.epl.pattern.core.PatternExpressionUtil;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleISO8601Parser;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpec;
import com.espertech.esper.common.internal.epl.pattern.observer.TimerScheduleSpecCompute;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.schedule.ScheduleParameterException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class TimerScheduleSpecComputeFromExpr
implements TimerScheduleSpecCompute {
    public static final EPTypeClass EPTYPE = new EPTypeClass(TimerScheduleSpecComputeFromExpr.class);
    private ExprEvaluator date;
    private ExprEvaluator repetitions;
    private TimePeriodEval timePeriod;

    public void setDate(ExprEvaluator date) {
        this.date = date;
    }

    public void setRepetitions(ExprEvaluator repetitions) {
        this.repetitions = repetitions;
    }

    public void setTimePeriod(TimePeriodEval timePeriod) {
        this.timePeriod = timePeriod;
    }

    @Override
    public TimerScheduleSpec compute(MatchedEventConvertor optionalConvertor, MatchedEventMap beginState, ExprEvaluatorContext exprEvaluatorContext, TimeZone timeZone, TimeAbacus timeAbacus) throws ScheduleParameterException {
        EventBean[] eventsPerStream = optionalConvertor == null ? null : optionalConvertor.convert(beginState);
        return TimerScheduleSpecComputeFromExpr.compute(this.date, this.repetitions, this.timePeriod, eventsPerStream, exprEvaluatorContext, timeZone, timeAbacus);
    }

    protected static TimerScheduleSpec compute(ExprEvaluator date, ExprEvaluator repetitions, TimePeriodEval timePeriod, EventBean[] eventsPerStream, ExprEvaluatorContext exprEvaluatorContext, TimeZone timeZone, TimeAbacus timeAbacus) throws ScheduleParameterException {
        Object param;
        Calendar optionalDate = null;
        Long optionalRemainder = null;
        if (date != null) {
            Object param2 = PatternExpressionUtil.evaluateChecked("Timer-schedule observer", date, eventsPerStream, exprEvaluatorContext);
            if (param2 instanceof String) {
                optionalDate = TimerScheduleISO8601Parser.parseDate((String)param2);
            } else if (param2 instanceof Number) {
                long msec = ((Number)param2).longValue();
                optionalDate = Calendar.getInstance(timeZone);
                optionalRemainder = timeAbacus.calendarSet(msec, optionalDate);
            } else if (param2 instanceof Calendar) {
                optionalDate = (Calendar)param2;
            } else if (param2 instanceof Date) {
                optionalDate = Calendar.getInstance(timeZone);
                optionalDate.setTimeInMillis(((Date)param2).getTime());
            } else if (param2 instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)param2;
                Date d = Date.from(ldt.atZone(timeZone.toZoneId()).toInstant());
                optionalDate = Calendar.getInstance(timeZone);
                optionalDate.setTimeInMillis(d.getTime());
            } else if (param2 instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)param2;
                optionalDate = GregorianCalendar.from(zdt);
            } else {
                if (param2 == null) {
                    throw new EPException("Null date-time value returned from date evaluation");
                }
                throw new EPException("Unrecognized date-time value " + param2.getClass());
            }
        }
        TimePeriod optionalTimePeriod = null;
        if (timePeriod != null) {
            try {
                optionalTimePeriod = timePeriod.timePeriodEval(eventsPerStream, true, exprEvaluatorContext);
            }
            catch (RuntimeException ex) {
                PatternExpressionUtil.handleRuntimeEx(ex, "Timer-schedule observer");
            }
        }
        Long optionalRepeatCount = null;
        if (repetitions != null && (param = PatternExpressionUtil.evaluateChecked("Timer-schedule observer", repetitions, eventsPerStream, exprEvaluatorContext)) != null) {
            optionalRepeatCount = ((Number)param).longValue();
        }
        if (optionalDate == null && optionalTimePeriod == null) {
            throw new EPException("Required date or time period are both null for Timer-schedule observer");
        }
        return new TimerScheduleSpec(optionalDate, optionalRemainder, optionalRepeatCount, optionalTimePeriod);
    }
}

