/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.pattern.or;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.EvalNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitor;
import com.espertech.esper.common.internal.epl.pattern.core.Evaluator;
import com.espertech.esper.common.internal.epl.pattern.or.EvalOrNode;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalOrStateNode
extends EvalStateNode
implements Evaluator {
    private final EvalOrNode evalOrNode;
    private final EvalStateNode[] childNodes;
    private boolean quitted;
    private static final Logger log = LoggerFactory.getLogger(EvalOrStateNode.class);

    public EvalOrStateNode(Evaluator parentNode, EvalOrNode evalOrNode) {
        super(parentNode);
        this.childNodes = new EvalStateNode[evalOrNode.getChildNodes().length];
        this.evalOrNode = evalOrNode;
    }

    @Override
    public void removeMatch(Set<EventBean> matchEvent) {
        for (EvalStateNode node : this.childNodes) {
            if (node == null) continue;
            node.removeMatch(matchEvent);
        }
    }

    @Override
    public EvalNode getFactoryNode() {
        return this.evalOrNode;
    }

    @Override
    public final void start(MatchedEventMap beginState) {
        AgentInstanceContext agentInstanceContext = this.evalOrNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternOrStart(this.evalOrNode.factoryNode, beginState);
        agentInstanceContext.getAuditProvider().patternInstance(true, this.evalOrNode.factoryNode, agentInstanceContext);
        int count = 0;
        for (EvalNode node : this.evalOrNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this);
            this.childNodes[count++] = childState;
        }
        EvalStateNode[] childNodeCopy = new EvalStateNode[this.childNodes.length];
        System.arraycopy(this.childNodes, 0, childNodeCopy, 0, this.childNodes.length);
        for (EvalStateNode child : childNodeCopy) {
            child.start(beginState);
            if (this.quitted) break;
        }
        agentInstanceContext.getInstrumentationProvider().aPatternOrStart();
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted, EventBean optionalTriggeringEvent) {
        AgentInstanceContext agentInstanceContext = this.evalOrNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternOrEvaluateTrue(this.evalOrNode.factoryNode, matchEvent);
        if (isQuitted) {
            for (int i = 0; i < this.childNodes.length; ++i) {
                if (this.childNodes[i] != fromNode) continue;
                this.childNodes[i] = null;
            }
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalOrNode.factoryNode, agentInstanceContext);
            this.quitInternal();
        }
        agentInstanceContext.getAuditProvider().patternTrue(this.evalOrNode.getFactoryNode(), this, matchEvent, isQuitted, agentInstanceContext);
        this.getParentEvaluator().evaluateTrue(matchEvent, this, isQuitted, optionalTriggeringEvent);
        agentInstanceContext.getInstrumentationProvider().aPatternOrEvaluateTrue(isQuitted);
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode, boolean restartable) {
        AgentInstanceContext agentInstanceContext = this.evalOrNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternOrEvalFalse(this.evalOrNode.factoryNode);
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] != fromNode) continue;
            this.childNodes[i] = null;
        }
        boolean allEmpty = true;
        for (int i = 0; i < this.childNodes.length; ++i) {
            if (this.childNodes[i] == null) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            agentInstanceContext.getAuditProvider().patternFalse(this.evalOrNode.getFactoryNode(), this, agentInstanceContext);
            agentInstanceContext.getAuditProvider().patternInstance(false, this.evalOrNode.factoryNode, agentInstanceContext);
            this.getParentEvaluator().evaluateFalse(this, true);
        }
        agentInstanceContext.getInstrumentationProvider().aPatternOrEvalFalse();
    }

    @Override
    public final void quit() {
        AgentInstanceContext agentInstanceContext = this.evalOrNode.getContext().getAgentInstanceContext();
        agentInstanceContext.getInstrumentationProvider().qPatternOrQuit(this.evalOrNode.factoryNode);
        agentInstanceContext.getAuditProvider().patternInstance(false, this.evalOrNode.factoryNode, agentInstanceContext);
        this.quitInternal();
        agentInstanceContext.getInstrumentationProvider().aPatternOrQuit();
    }

    @Override
    public final void accept(EvalStateNodeVisitor visitor) {
        visitor.visitOr(this.evalOrNode.getFactoryNode(), this);
        for (EvalStateNode node : this.childNodes) {
            if (node == null) continue;
            node.accept(visitor);
        }
    }

    @Override
    public boolean isNotOperator() {
        return false;
    }

    @Override
    public boolean isFilterStateNode() {
        return false;
    }

    @Override
    public boolean isFilterChildNonQuitting() {
        return false;
    }

    @Override
    public boolean isObserverStateNodeNonRestarting() {
        return false;
    }

    public final String toString() {
        return "EvalOrStateNode";
    }

    private void quitInternal() {
        for (EvalStateNode child : this.childNodes) {
            if (child == null) continue;
            child.quit();
        }
        Arrays.fill(this.childNodes, null);
        this.quitted = true;
    }
}

