/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.grouped;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInstanceAux;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyCodegen;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.resultset.codegen.ResultSetProcessorCodegenNames;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorUtil;
import com.espertech.esper.common.internal.epl.resultset.rowperevent.ResultSetProcessorRowPerEventImpl;
import com.espertech.esper.common.internal.epl.resultset.rowpergroup.ResultSetProcessorRowPerGroup;
import com.espertech.esper.common.internal.epl.util.EPTypeCollectionConst;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import java.util.Set;
import java.util.function.Consumer;

public class ResultSetProcessorGroupedUtil {
    public static final String METHOD_APPLYAGGVIEWRESULTKEYEDVIEW = "applyAggViewResultKeyedView";
    public static final String METHOD_APPLYAGGJOINRESULTKEYEDJOIN = "applyAggJoinResultKeyedJoin";

    public static void applyAggViewResultKeyedView(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, EventBean[] newData, Object[] newDataMultiKey, EventBean[] oldData, Object[] oldDataMultiKey, EventBean[] eventsPerStream) {
        int i;
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], exprEvaluatorContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], exprEvaluatorContext);
            }
        }
    }

    public static void applyAggJoinResultKeyedJoin(AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext, Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Object[] newDataMultiKey, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, Object[] oldDataMultiKey) {
        int count;
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKeyArrayOfKeys<EventBean> eventsPerStream : newEvents) {
                aggregationService.applyEnter(eventsPerStream.getArray(), newDataMultiKey[count], exprEvaluatorContext);
                ++count;
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            count = 0;
            for (MultiKeyArrayOfKeys<EventBean> eventsPerStream : oldEvents) {
                aggregationService.applyLeave(eventsPerStream.getArray(), oldDataMultiKey[count], exprEvaluatorContext);
                ++count;
            }
        }
    }

    public static CodegenMethod generateGroupKeySingleCodegen(ExprNode[] groupKeyExpressions, MultiKeyClassRef optionalMultiKeyClasses, CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = methodNode -> {
            String[] expressions = null;
            if (classScope.isInstrumented()) {
                expressions = ExprNodeUtilityPrint.toExpressionStringsMinPrecedence(groupKeyExpressions);
            }
            methodNode.getBlock().apply(InstrumentationCode.instblock(classScope, "qResultSetProcessComputeGroupKeys", ExprForgeCodegenNames.REF_ISNEWDATA, CodegenExpressionBuilder.constant(expressions), ExprForgeCodegenNames.REF_EPS));
            if (optionalMultiKeyClasses != null && optionalMultiKeyClasses.getClassNameMK() != null) {
                CodegenMethod method = MultiKeyCodegen.codegenMethod(groupKeyExpressions, optionalMultiKeyClasses, methodNode, classScope);
                methodNode.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "key", (CodegenExpression)CodegenExpressionBuilder.localMethod(method, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT)).apply(InstrumentationCode.instblock(classScope, "aResultSetProcessComputeGroupKeys", ExprForgeCodegenNames.REF_ISNEWDATA, CodegenExpressionBuilder.ref("key"))).methodReturn(CodegenExpressionBuilder.ref("key"));
                return;
            }
            if (groupKeyExpressions.length > 1) {
                throw new IllegalStateException("Multiple group-by expression and no multikey");
            }
            CodegenMethod expression = CodegenLegoMethodExpression.codegenExpression(groupKeyExpressions[0].getForge(), methodNode, classScope);
            methodNode.getBlock().declareVar(EPTypePremade.OBJECT.getEPType(), "key", (CodegenExpression)CodegenExpressionBuilder.localMethod(expression, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ResultSetProcessorCodegenNames.MEMBER_EXPREVALCONTEXT)).apply(InstrumentationCode.instblock(classScope, "aResultSetProcessComputeGroupKeys", ExprForgeCodegenNames.REF_ISNEWDATA, CodegenExpressionBuilder.ref("key"))).methodReturn(CodegenExpressionBuilder.ref("key"));
        };
        return instance.getMethods().addMethod(EPTypePremade.OBJECT.getEPType(), "generateGroupKeySingle", CodegenNamedParam.from(EventBean.EPTYPEARRAY, "eventsPerStream", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData"), ResultSetProcessorUtil.class, classScope, code);
    }

    public static CodegenMethod generateGroupKeyArrayViewCodegen(CodegenMethod generateGroupKeySingle, CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = method -> {
            method.getBlock().ifRefNullReturnNull("events").declareVar(EventBean.EPTYPEARRAY, "eventsPerStream", CodegenExpressionBuilder.newArrayByLength(EventBean.EPTYPE, CodegenExpressionBuilder.constant(1))).declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "keys", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events"))));
            CodegenBlock forLoop = method.getBlock().forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("events")));
            forLoop.assignArrayElement("eventsPerStream", CodegenExpressionBuilder.constant(0), CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("events"), CodegenExpressionBuilder.ref("i"))).assignArrayElement("keys", (CodegenExpression)CodegenExpressionBuilder.ref("i"), (CodegenExpression)CodegenExpressionBuilder.localMethod(generateGroupKeySingle, CodegenExpressionBuilder.ref("eventsPerStream"), ExprForgeCodegenNames.REF_ISNEWDATA));
            method.getBlock().methodReturn(CodegenExpressionBuilder.ref("keys"));
        };
        return instance.getMethods().addMethod(EPTypePremade.OBJECTARRAY.getEPType(), "generateGroupKeyArrayView", CodegenNamedParam.from(EventBean.EPTYPEARRAY, "events", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData"), ResultSetProcessorRowPerGroup.class, classScope, code);
    }

    public static CodegenMethod generateGroupKeyArrayJoinCodegen(CodegenMethod generateGroupKeySingle, CodegenClassScope classScope, CodegenInstanceAux instance) {
        Consumer<CodegenMethod> code = method -> method.getBlock().ifCondition(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("resultSet"), "isEmpty", new CodegenExpression[0])).blockReturn(CodegenExpressionBuilder.constantNull()).declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "keys", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("resultSet"), "size", new CodegenExpression[0]))).declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "count", CodegenExpressionBuilder.constant(0)).forEach(MultiKeyArrayOfKeys.EPTYPE, "eventsPerStream", CodegenExpressionBuilder.ref("resultSet")).assignArrayElement("keys", (CodegenExpression)CodegenExpressionBuilder.ref("count"), (CodegenExpression)CodegenExpressionBuilder.localMethod(generateGroupKeySingle, CodegenExpressionBuilder.cast(EventBean.EPTYPEARRAY, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("eventsPerStream"), "getArray", new CodegenExpression[0])), ExprForgeCodegenNames.REF_ISNEWDATA)).incrementRef("count").blockEnd().methodReturn(CodegenExpressionBuilder.ref("keys"));
        return instance.getMethods().addMethod(EPTypePremade.OBJECTARRAY.getEPType(), "generateGroupKeyArrayJoin", CodegenNamedParam.from(EPTypeCollectionConst.EPTYPE_SET_MULTIKEYARRAYOFKEYS_EVENTBEAN, "resultSet", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData"), ResultSetProcessorRowPerEventImpl.class, classScope, code);
    }
}

