/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.resultset.rowperevent;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.MultiKeyArrayOfKeys;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.epl.resultset.rowperevent.ResultSetProcessorRowPerEvent;
import com.espertech.esper.common.internal.epl.resultset.rowperevent.ResultSetProcessorRowPerEventOutputAllHelper;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ResultSetProcessorRowPerEventOutputAllHelperImpl
implements ResultSetProcessorRowPerEventOutputAllHelper {
    private final ResultSetProcessorRowPerEvent processor;
    private final Deque<EventBean> eventsOld = new ArrayDeque<EventBean>(2);
    private final Deque<EventBean> eventsNew = new ArrayDeque<EventBean>(2);

    public ResultSetProcessorRowPerEventOutputAllHelperImpl(ResultSetProcessorRowPerEvent processor) {
        this.processor = processor;
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        UniformPair<EventBean[]> pair = this.processor.processViewResult(newData, oldData, isGenerateSynthetic);
        this.apply(pair);
    }

    @Override
    public void processJoin(Set<MultiKeyArrayOfKeys<EventBean>> newEvents, Set<MultiKeyArrayOfKeys<EventBean>> oldEvents, boolean isGenerateSynthetic) {
        UniformPair<EventBean[]> pair = this.processor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        this.apply(pair);
    }

    @Override
    public UniformPair<EventBean[]> output() {
        EventBean[] oldEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsOld);
        EventBean[] newEvents = EventBeanUtility.toArrayNullIfEmpty(this.eventsNew);
        UniformPair<EventBean[]> result = null;
        if (oldEvents != null || newEvents != null) {
            result = new UniformPair<EventBean[]>(newEvents, oldEvents);
        }
        this.eventsOld.clear();
        this.eventsNew.clear();
        return result;
    }

    @Override
    public void destroy() {
    }

    private void apply(UniformPair<EventBean[]> pair) {
        if (pair == null) {
            return;
        }
        EventBeanUtility.addToCollection(pair.getFirst(), this.eventsNew);
        EventBeanUtility.addToCollection(pair.getSecond(), this.eventsOld);
    }
}

