/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewUtil;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.Comparator;
import java.util.Map;

public class RowRecogPartitionTerminationStateComparator
implements Comparator<RowRecogNFAStateEntry> {
    private final int[] multimatchStreamNumToVariable;
    private final Map<String, Pair<Integer, Boolean>> variableStreams;

    public RowRecogPartitionTerminationStateComparator(int[] multimatchStreamNumToVariable, Map<String, Pair<Integer, Boolean>> variableStreams) {
        this.multimatchStreamNumToVariable = multimatchStreamNumToVariable;
        this.variableStreams = variableStreams;
    }

    @Override
    public int compare(RowRecogNFAStateEntry o1, RowRecogNFAStateEntry o2) {
        return this.compareTerminationStateToEndState(o1, o2) ? 0 : 1;
    }

    public boolean compareTerminationStateToEndState(RowRecogNFAStateEntry terminationState, RowRecogNFAStateEntry endState) {
        if (terminationState.getMatchBeginEventSeqNo() != endState.getMatchBeginEventSeqNo()) {
            return false;
        }
        for (Map.Entry<String, Pair<Integer, Boolean>> entry : this.variableStreams.entrySet()) {
            int stream = entry.getValue().getFirst();
            boolean multi = entry.getValue().getSecond();
            if (multi) {
                EventBean[] termStreamEvents = RowRecogNFAViewUtil.getMultimatchArray(this.multimatchStreamNumToVariable, terminationState, stream);
                EventBean[] endStreamEvents = RowRecogNFAViewUtil.getMultimatchArray(this.multimatchStreamNumToVariable, endState, stream);
                if (endStreamEvents == null) continue;
                if (termStreamEvents == null) {
                    return false;
                }
                for (int i = 0; i < endStreamEvents.length; ++i) {
                    if (termStreamEvents.length <= i || EventBeanUtility.eventsAreEqualsAllowNull(endStreamEvents[i], termStreamEvents[i])) continue;
                    return false;
                }
                continue;
            }
            EventBean termStreamEvent = terminationState.getEventsPerStream()[stream];
            EventBean endStreamEvent = endState.getEventsPerStream()[stream];
            if (EventBeanUtility.eventsAreEqualsAllowNull(endStreamEvent, termStreamEvent)) continue;
            return false;
        }
        return true;
    }
}

