/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.core;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.collection.PermutationEnumeration;
import com.espertech.esper.common.internal.compile.stage1.specmapper.ExpressionCopier;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFATypeEnum;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNode;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeAlteration;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeAtom;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeConcatenation;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeNested;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodePermute;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprNodeVisitorRepeat;
import com.espertech.esper.common.internal.epl.rowrecog.expr.RowRecogExprRepeatDesc;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RowRecogPatternExpandUtil {
    private static final RowRegexExprNodeCopierAtom ATOM_HANDLER = new RowRegexExprNodeCopierAtom();
    private static final RowRegexExprNodeCopierNested NESTED_HANDLER = new RowRegexExprNodeCopierNested();

    public static RowRecogExprNode expand(RowRecogExprNode pattern, ExpressionCopier expressionCopier) throws ExprValidationException {
        RowRecogExprNodeVisitorRepeat visitor = new RowRecogExprNodeVisitorRepeat();
        pattern.accept(visitor);
        RowRecogExprNode newParentNode = pattern;
        List<RowRecogExprNodeVisitorRepeat.RowRegexPermuteDesc> permutes = visitor.getPermutes();
        Collections.sort(permutes, new Comparator<RowRecogExprNodeVisitorRepeat.RowRegexPermuteDesc>(){

            @Override
            public int compare(RowRecogExprNodeVisitorRepeat.RowRegexPermuteDesc o1, RowRecogExprNodeVisitorRepeat.RowRegexPermuteDesc o2) {
                if (o1.getLevel() > o2.getLevel()) {
                    return -1;
                }
                return o1.getLevel() == o2.getLevel() ? 0 : 1;
            }
        });
        for (RowRecogExprNodeVisitorRepeat.RowRegexPermuteDesc rowRegexPermuteDesc : permutes) {
            RowRecogExprNodeAlteration rowRecogExprNodeAlteration = RowRecogPatternExpandUtil.expandPermute(rowRegexPermuteDesc.getPermute(), expressionCopier);
            RowRecogExprNode optionalNewParent = RowRecogPatternExpandUtil.replace(rowRegexPermuteDesc.getOptionalParent(), rowRegexPermuteDesc.getPermute(), Collections.singletonList(rowRecogExprNodeAlteration));
            if (optionalNewParent == null) continue;
            newParentNode = optionalNewParent;
        }
        List<Pair<RowRecogExprNodeAtom, RowRecogExprNode>> atomPairs = visitor.getAtoms();
        for (Pair<RowRecogExprNodeAtom, RowRecogExprNode> pair : atomPairs) {
            RowRecogExprNodeAtom atom = pair.getFirst();
            List<RowRecogExprNode> expandedRepeat = RowRecogPatternExpandUtil.expandRepeat(atom, atom.getOptionalRepeat(), atom.getType(), ATOM_HANDLER, expressionCopier);
            RowRecogExprNode optionalNewParent = RowRecogPatternExpandUtil.replace(pair.getSecond(), pair.getFirst(), expandedRepeat);
            if (optionalNewParent == null) continue;
            newParentNode = optionalNewParent;
        }
        List<RowRecogExprNodeVisitorRepeat.RowRegexNestedDesc> list = visitor.getNesteds();
        Collections.sort(list, new Comparator<RowRecogExprNodeVisitorRepeat.RowRegexNestedDesc>(){

            @Override
            public int compare(RowRecogExprNodeVisitorRepeat.RowRegexNestedDesc o1, RowRecogExprNodeVisitorRepeat.RowRegexNestedDesc o2) {
                if (o1.getLevel() > o2.getLevel()) {
                    return -1;
                }
                return o1.getLevel() == o2.getLevel() ? 0 : 1;
            }
        });
        for (RowRecogExprNodeVisitorRepeat.RowRegexNestedDesc pair : list) {
            RowRecogExprNodeNested nested = pair.getNested();
            List<RowRecogExprNode> expandedRepeat = RowRecogPatternExpandUtil.expandRepeat(nested, nested.getOptionalRepeat(), nested.getType(), NESTED_HANDLER, expressionCopier);
            RowRecogExprNode optionalNewParent = RowRecogPatternExpandUtil.replace(pair.getOptionalParent(), pair.getNested(), expandedRepeat);
            if (optionalNewParent == null) continue;
            newParentNode = optionalNewParent;
        }
        return newParentNode;
    }

    private static RowRecogExprNodeAlteration expandPermute(RowRecogExprNodePermute permute, ExpressionCopier expressionCopier) {
        PermutationEnumeration e = new PermutationEnumeration(permute.getChildNodes().size());
        RowRecogExprNodeAlteration parent = new RowRecogExprNodeAlteration();
        while (e.hasMoreElements()) {
            int[] indexes = e.nextElement();
            RowRecogExprNodeConcatenation concat = new RowRecogExprNodeConcatenation();
            parent.addChildNode(concat);
            for (int i = 0; i < indexes.length; ++i) {
                RowRecogExprNode toCopy = permute.getChildNodes().get(indexes[i]);
                RowRecogExprNode copy = toCopy.checkedCopy(expressionCopier);
                concat.addChildNode(copy);
            }
        }
        return parent;
    }

    private static RowRecogExprNode replace(RowRecogExprNode optionalParent, RowRecogExprNode originalNode, List<RowRecogExprNode> expandedRepeat) {
        if (optionalParent == null) {
            RowRecogExprNodeConcatenation newParentNode = new RowRecogExprNodeConcatenation();
            newParentNode.getChildNodes().addAll(expandedRepeat);
            return newParentNode;
        }
        if (optionalParent instanceof RowRecogExprNodeNested || optionalParent instanceof RowRecogExprNodeAlteration) {
            RowRecogExprNodeConcatenation concatenation = new RowRecogExprNodeConcatenation();
            concatenation.getChildNodes().addAll(expandedRepeat);
            optionalParent.replaceChildNode(originalNode, Collections.singletonList(concatenation));
        } else {
            optionalParent.replaceChildNode(originalNode, expandedRepeat);
        }
        return null;
    }

    private static List<RowRecogExprNode> expandRepeat(RowRecogExprNode node, RowRecogExprRepeatDesc repeat, RowRecogNFATypeEnum type, RowRegexExprNodeCopier copier, ExpressionCopier expressionCopier) throws ExprValidationException {
        ArrayList<RowRecogExprNode> repeated = new ArrayList<RowRecogExprNode>();
        if (repeat.getSingle() != null) {
            RowRecogPatternExpandUtil.validateExpression(repeat.getSingle());
            int numRepeated = (Integer)repeat.getSingle().getForge().getExprEvaluator().evaluate(null, true, null);
            RowRecogPatternExpandUtil.validateRange(numRepeated, 1, Integer.MAX_VALUE);
            for (int i = 0; i < numRepeated; ++i) {
                RowRecogExprNode copy = copier.copy(node, type, expressionCopier);
                repeated.add(copy);
            }
            return repeated;
        }
        Integer lower = null;
        Integer upper = null;
        if (repeat.getLower() != null) {
            RowRecogPatternExpandUtil.validateExpression(repeat.getLower());
            lower = (Integer)repeat.getLower().getForge().getExprEvaluator().evaluate(null, true, null);
        }
        if (repeat.getUpper() != null) {
            RowRecogPatternExpandUtil.validateExpression(repeat.getUpper());
            upper = (Integer)repeat.getUpper().getForge().getExprEvaluator().evaluate(null, true, null);
        }
        if (lower != null && upper != null) {
            int i;
            RowRecogPatternExpandUtil.validateRange(lower, 1, Integer.MAX_VALUE);
            RowRecogPatternExpandUtil.validateRange(upper, 1, Integer.MAX_VALUE);
            RowRecogPatternExpandUtil.validateRange(lower, 1, upper);
            for (i = 0; i < lower; ++i) {
                RowRecogExprNode copy = copier.copy(node, type, expressionCopier);
                repeated.add(copy);
            }
            for (i = lower.intValue(); i < upper; ++i) {
                RowRecogNFATypeEnum newType = type;
                if (type == RowRecogNFATypeEnum.SINGLE) {
                    newType = RowRecogNFATypeEnum.ONE_OPTIONAL;
                } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY) {
                    newType = RowRecogNFATypeEnum.ZERO_TO_MANY;
                } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY_RELUCTANT) {
                    newType = RowRecogNFATypeEnum.ZERO_TO_MANY_RELUCTANT;
                }
                RowRecogExprNode copy = copier.copy(node, newType, expressionCopier);
                repeated.add(copy);
            }
            return repeated;
        }
        if (upper == null) {
            RowRecogExprNode copy;
            RowRecogPatternExpandUtil.validateRange(lower, 1, Integer.MAX_VALUE);
            for (int i = 0; i < lower; ++i) {
                copy = copier.copy(node, type, expressionCopier);
                repeated.add(copy);
            }
            RowRecogNFATypeEnum newType = type;
            if (type == RowRecogNFATypeEnum.SINGLE) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY;
            } else if (type == RowRecogNFATypeEnum.ONE_OPTIONAL) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY;
            } else if (type == RowRecogNFATypeEnum.ONE_OPTIONAL_RELUCTANT) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY_RELUCTANT;
            } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY;
            } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY_RELUCTANT) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY_RELUCTANT;
            }
            copy = copier.copy(node, newType, expressionCopier);
            repeated.add(copy);
            return repeated;
        }
        RowRecogPatternExpandUtil.validateRange(upper, 1, Integer.MAX_VALUE);
        for (int i = 0; i < upper; ++i) {
            RowRecogNFATypeEnum newType = type;
            if (type == RowRecogNFATypeEnum.SINGLE) {
                newType = RowRecogNFATypeEnum.ONE_OPTIONAL;
            } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY;
            } else if (type == RowRecogNFATypeEnum.ONE_TO_MANY_RELUCTANT) {
                newType = RowRecogNFATypeEnum.ZERO_TO_MANY_RELUCTANT;
            }
            RowRecogExprNode copy = copier.copy(node, newType, expressionCopier);
            repeated.add(copy);
        }
        return repeated;
    }

    private static void validateRange(int value, int min, int maxValue) throws ExprValidationException {
        if (value < min || value > maxValue) {
            String message = "Invalid pattern quantifier value " + value + ", expecting a minimum of " + min;
            if (maxValue != Integer.MAX_VALUE) {
                message = message + " and maximum of " + maxValue;
            }
            throw new ExprValidationException(message);
        }
    }

    private static void validateExpression(ExprNode repeat) throws ExprValidationException {
        ExprNodeUtilityValidate.validatePlainExpression(ExprNodeOrigin.MATCHRECOGPATTERN, repeat);
        if (!(repeat instanceof ExprConstantNode)) {
            throw new ExprValidationException(RowRecogPatternExpandUtil.getPatternQuantifierExpressionText(repeat) + " must return a constant value");
        }
        EPType evalType = repeat.getForge().getEvaluationType();
        if (!JavaClassHelper.isTypeInteger(evalType)) {
            throw new ExprValidationException(RowRecogPatternExpandUtil.getPatternQuantifierExpressionText(repeat) + " must return an integer-type value");
        }
    }

    private static String getPatternQuantifierExpressionText(ExprNode exprNode) {
        return "Pattern quantifier '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(exprNode) + "'";
    }

    private static class RowRegexExprNodeCopierAtom
    implements RowRegexExprNodeCopier {
        private RowRegexExprNodeCopierAtom() {
        }

        @Override
        public RowRecogExprNode copy(RowRecogExprNode nodeToCopy, RowRecogNFATypeEnum newType, ExpressionCopier expressionCopier) {
            RowRecogExprNodeAtom atom = (RowRecogExprNodeAtom)nodeToCopy;
            return new RowRecogExprNodeAtom(atom.getTag(), newType, null);
        }
    }

    private static interface RowRegexExprNodeCopier {
        public RowRecogExprNode copy(RowRecogExprNode var1, RowRecogNFATypeEnum var2, ExpressionCopier var3);
    }

    private static class RowRegexExprNodeCopierNested
    implements RowRegexExprNodeCopier {
        private RowRegexExprNodeCopierNested() {
        }

        @Override
        public RowRecogExprNode copy(RowRecogExprNode nodeToCopy, RowRecogNFATypeEnum newType, ExpressionCopier expressionCopier) {
            RowRecogExprNodeNested nested = (RowRecogExprNodeNested)nodeToCopy;
            RowRecogExprNodeNested nestedCopy = new RowRecogExprNodeNested(newType, null);
            for (RowRecogExprNode inner : nested.getChildNodes()) {
                RowRecogExprNode innerCopy = inner.checkedCopy(expressionCopier);
                nestedCopy.addChildNode(innerCopy);
            }
            return nestedCopy;
        }
    }
}

