/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.state;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogNFAViewServiceVisitor;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPartitionTerminationStateComparator;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategyImpl;
import com.espertech.esper.common.internal.epl.rowrecog.nfa.RowRecogNFAStateEntry;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionState;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateImpl;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepo;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepoGroupMeta;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepoScheduleState;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogPartitionStateRepoScheduleStateImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RowRecogPartitionStateRepoGroup
implements RowRecogPartitionStateRepo {
    public static final int INITIAL_COLLECTION_MIN = 100;
    private final RowRecogPartitionStateRepoGroupMeta meta;
    private final RowRecogPreviousStrategyImpl getter;
    private final Map<Object, RowRecogPartitionStateImpl> states;
    private final RowRecogPartitionStateRepoScheduleStateImpl optionalIntervalSchedules;
    private int currentCollectionSize = 100;
    private int eventSequenceNumber;

    public RowRecogPartitionStateRepoGroup(RowRecogPreviousStrategyImpl getter, RowRecogPartitionStateRepoGroupMeta meta, boolean keepScheduleState, RowRecogPartitionTerminationStateComparator terminationStateCompare) {
        this.getter = getter;
        this.meta = meta;
        this.states = new HashMap<Object, RowRecogPartitionStateImpl>();
        this.optionalIntervalSchedules = keepScheduleState ? new RowRecogPartitionStateRepoScheduleStateImpl(terminationStateCompare) : null;
    }

    @Override
    public int incrementAndGetEventSequenceNum() {
        ++this.eventSequenceNumber;
        return this.eventSequenceNumber;
    }

    @Override
    public void setEventSequenceNum(int num) {
        this.eventSequenceNumber = num;
    }

    @Override
    public RowRecogPartitionStateRepoScheduleState getScheduleState() {
        return this.optionalIntervalSchedules;
    }

    @Override
    public void removeState(Object partitionKey) {
        this.states.remove(partitionKey);
    }

    @Override
    public RowRecogPartitionStateRepo copyForIterate(boolean forOutOfOrderReprocessing) {
        RowRecogPartitionStateRepoGroup copy = new RowRecogPartitionStateRepoGroup(this.getter, this.meta, false, null);
        for (Map.Entry<Object, RowRecogPartitionStateImpl> entry : this.states.entrySet()) {
            copy.states.put(entry.getKey(), new RowRecogPartitionStateImpl(entry.getValue().getRandomAccess(), entry.getKey()));
        }
        return copy;
    }

    @Override
    public int removeOld(EventBean[] oldData, boolean isEmpty, boolean[] found) {
        if (isEmpty) {
            int countRemoved;
            if (this.getter == null) {
                countRemoved = this.getStateCount();
                this.states.clear();
            } else {
                countRemoved = 0;
                for (Map.Entry<Object, RowRecogPartitionStateImpl> entry : this.states.entrySet()) {
                    countRemoved += entry.getValue().getNumStates();
                    entry.getValue().setCurrentStates(Collections.emptyList());
                }
            }
            if (this.getter != null) {
                for (int i = 0; i < oldData.length; ++i) {
                    RowRecogPartitionStateImpl partitionState = this.getState(oldData[i], true);
                    if (partitionState == null) continue;
                    partitionState.removeEventFromPrev(oldData);
                }
            }
            return countRemoved;
        }
        int countRemoved = 0;
        for (int i = 0; i < oldData.length; ++i) {
            RowRecogPartitionStateImpl partitionState = this.getState(oldData[i], true);
            if (partitionState == null) continue;
            if (found[i]) {
                boolean cleared;
                countRemoved += partitionState.removeEventFromState(oldData[i]);
                boolean bl = cleared = partitionState.getNumStates() == 0;
                if (cleared && this.getter == null) {
                    this.states.remove(partitionState.getOptionalKeys());
                }
            }
            partitionState.removeEventFromPrev(oldData[i]);
        }
        return countRemoved;
    }

    @Override
    public RowRecogPartitionState getState(Object key) {
        return this.states.get(key);
    }

    @Override
    public RowRecogPartitionStateImpl getState(EventBean theEvent, boolean isCollect) {
        Object key;
        RowRecogPartitionStateImpl state;
        this.meta.getAgentInstanceContext().getInstrumentationProvider().qRegExPartition(theEvent);
        if (isCollect && this.states.size() >= this.currentCollectionSize) {
            ArrayList<Object> removeList = new ArrayList<Object>();
            for (Map.Entry<Object, RowRecogPartitionStateImpl> entry : this.states.entrySet()) {
                if (!entry.getValue().isEmptyCurrentState() || entry.getValue().getRandomAccess() != null && !entry.getValue().getRandomAccess().isEmpty()) continue;
                removeList.add(entry.getKey());
            }
            for (Map.Entry<Object, RowRecogPartitionStateImpl> entry : removeList) {
                this.states.remove(entry);
            }
            if (removeList.size() < this.currentCollectionSize / 5) {
                this.currentCollectionSize *= 2;
            }
        }
        if ((state = this.states.get(key = RowRecogPartitionStateRepoGroup.getKeys(theEvent, this.meta))) != null) {
            this.meta.getAgentInstanceContext().getInstrumentationProvider().aRegExPartition(true, key, state);
            return state;
        }
        state = new RowRecogPartitionStateImpl(this.getter, new ArrayList<RowRecogNFAStateEntry>(), key);
        this.states.put(key, state);
        this.meta.getAgentInstanceContext().getInstrumentationProvider().aRegExPartition(false, key, state);
        return state;
    }

    @Override
    public void accept(RowRecogNFAViewServiceVisitor visitor) {
        visitor.visitPartitioned(this.states);
    }

    @Override
    public boolean isPartitioned() {
        return true;
    }

    public Map<Object, RowRecogPartitionStateImpl> getStates() {
        return this.states;
    }

    @Override
    public int getStateCount() {
        int total = 0;
        for (Map.Entry<Object, RowRecogPartitionStateImpl> entry : this.states.entrySet()) {
            total += entry.getValue().getNumStates();
        }
        return total;
    }

    public static Object getKeys(EventBean theEvent, RowRecogPartitionStateRepoGroupMeta meta) {
        EventBean[] eventsPerStream = meta.getEventsPerStream();
        eventsPerStream[0] = theEvent;
        return meta.getPartitionExpression().evaluate(eventsPerStream, true, meta.getAgentInstanceContext());
    }

    @Override
    public void destroy() {
    }
}

