/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.rowrecog.state;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.RollingEventBuffer;
import com.espertech.esper.common.internal.epl.rowrecog.core.RowRecogPreviousStrategyImpl;
import com.espertech.esper.common.internal.epl.rowrecog.state.RowRecogStateRandomAccess;
import java.util.HashMap;
import java.util.Map;

public class RowRecogStateRandomAccessImpl
implements RowRecogStateRandomAccess {
    private final RowRecogPreviousStrategyImpl getter;
    private final Map<EventBean, EventBean[]> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastNew;

    public RowRecogStateRandomAccessImpl(RowRecogPreviousStrategyImpl getter) {
        this.getter = getter;
        this.newEvents = new RollingEventBuffer(getter.getMaxPriorIndex() + 1);
        this.priorEventMap = !getter.isUnbound() ? new HashMap<EventBean, EventBean[]>() : null;
    }

    @Override
    public void newEventPrepare(EventBean newEvent) {
        this.newEvents.add(newEvent);
        EventBean[] priorEvents = new EventBean[this.getter.getIndexesRequestedLen()];
        for (int j = 0; j < priorEvents.length; ++j) {
            int priorIndex = this.getter.getIndexesRequested()[j];
            priorEvents[j] = this.newEvents.get(priorIndex);
        }
        if (this.priorEventMap != null) {
            this.priorEventMap.put(newEvent, priorEvents);
        }
        this.lastNew = priorEvents;
        this.getter.setRandomAccess(this);
    }

    @Override
    public void existingEventPrepare(EventBean newEvent) {
        if (this.priorEventMap != null) {
            this.lastNew = this.priorEventMap.get(newEvent);
        }
        this.getter.setRandomAccess(this);
    }

    @Override
    public EventBean getPreviousEvent(int assignedRelativeIndex) {
        if (this.lastNew == null) {
            return null;
        }
        return this.lastNew[assignedRelativeIndex];
    }

    @Override
    public void remove(EventBean[] oldEvents) {
        if (oldEvents == null) {
            return;
        }
        for (int i = 0; i < oldEvents.length; ++i) {
            this.remove(oldEvents[i]);
        }
    }

    @Override
    public void remove(EventBean oldEvent) {
        if (this.priorEventMap != null) {
            this.priorEventMap.remove(oldEvent);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.priorEventMap != null) {
            this.priorEventMap.isEmpty();
        }
        return true;
    }
}

