/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.core;

import com.espertech.esper.common.client.hook.expr.EPLScriptContext;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.script.core.ExpressionScriptCompiled;
import com.espertech.esper.common.internal.epl.script.jsr223.JSR223Helper;
import com.espertech.esper.common.internal.epl.script.mvel.MVELHelper;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import java.util.HashMap;
import java.util.Locale;

public class ExpressionNodeScriptCompiler {
    public static ExpressionScriptCompiled compileScript(String dialect, String scriptName, String expression, String[] parameterNames, EPType[] evaluationTypes, ExpressionScriptCompiled optionalPrecompiled, ClasspathImportService classpathImportService) throws ExprValidationException {
        HashMap<String, Class> mvelInputParamTypes;
        if (dialect.toLowerCase(Locale.ENGLISH).trim().equals("mvel")) {
            mvelInputParamTypes = new HashMap<String, Class>();
            for (int i = 0; i < parameterNames.length; ++i) {
                String mvelParamName = parameterNames[i];
                EPType type = evaluationTypes[i];
                Class parameterClass = type == null || type == EPTypeNull.INSTANCE ? Object.class : ((EPTypeClass)type).getClass();
                mvelInputParamTypes.put(mvelParamName, parameterClass);
            }
        } else {
            if (optionalPrecompiled != null) {
                return optionalPrecompiled;
            }
            return JSR223Helper.verifyCompileScript(scriptName, expression, dialect);
        }
        mvelInputParamTypes.put("epl", EPLScriptContext.class);
        ExpressionScriptCompiled compiled = MVELHelper.compile(scriptName, expression, mvelInputParamTypes, classpathImportService);
        return compiled;
    }
}

