/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Collection;

public class NameParamNumAndModule {
    public static final EPTypeClass EPTYPE = new EPTypeClass(NameParamNumAndModule.class);
    public static final NameParamNumAndModule[] EMPTY_ARRAY = new NameParamNumAndModule[0];
    private final String name;
    private final int paramNum;
    private final String moduleName;

    public NameParamNumAndModule(String name, int paramNum, String moduleName) {
        this.name = name;
        this.paramNum = paramNum;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public int getParamNum() {
        return this.paramNum;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameParamNumAndModule that = (NameParamNumAndModule)o;
        if (this.paramNum != that.paramNum) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.moduleName != null ? this.moduleName.equals(that.moduleName) : that.moduleName == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.paramNum;
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        return result;
    }

    public static CodegenExpression makeArrayNullIfEmpty(Collection<NameParamNumAndModule> names) {
        if (names.isEmpty()) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpression[] expressions = new CodegenExpression[names.size()];
        int count = 0;
        for (NameParamNumAndModule entry : names) {
            expressions[count++] = entry.make();
        }
        return CodegenExpressionBuilder.newArrayWithInit(EPTYPE, expressions);
    }

    private CodegenExpression make() {
        return CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.constant(this.name), CodegenExpressionBuilder.constant(this.paramNum), CodegenExpressionBuilder.constant(this.moduleName));
    }
}

