/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.script.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.script.core.ExpressionNodeScriptCompiler;
import com.espertech.esper.common.internal.epl.script.core.ExpressionScriptCompiled;
import com.espertech.esper.common.internal.epl.script.core.ScriptDescriptorRuntime;
import com.espertech.esper.common.internal.epl.script.core.ScriptEvaluator;
import com.espertech.esper.common.internal.epl.script.jsr223.ExpressionScriptCompiledJSR223;
import com.espertech.esper.common.internal.epl.script.jsr223.ScriptEvaluatorJSR223;
import com.espertech.esper.common.internal.epl.script.mvel.ExpressionScriptCompiledMVEL;
import com.espertech.esper.common.internal.epl.script.mvel.ScriptEvaluatorMVEL;

public class ScriptEvaluatorCompilerRuntime {
    public static ScriptEvaluator compileScriptEval(ScriptDescriptorRuntime descriptor) {
        ExpressionScriptCompiled compiled;
        String dialect = descriptor.getOptionalDialect() == null ? descriptor.getDefaultDialect() : descriptor.getOptionalDialect();
        try {
            compiled = ExpressionNodeScriptCompiler.compileScript(dialect, descriptor.getScriptName(), descriptor.getExpression(), descriptor.getParameterNames(), descriptor.getEvaluationTypes(), null, descriptor.getClasspathImportService());
        }
        catch (ExprValidationException ex) {
            throw new EPException("Failed to compile script '" + descriptor.getScriptName() + "': " + ex.getMessage());
        }
        if (compiled instanceof ExpressionScriptCompiledJSR223) {
            ExpressionScriptCompiledJSR223 jsr223 = (ExpressionScriptCompiledJSR223)compiled;
            return new ScriptEvaluatorJSR223(descriptor.getScriptName(), descriptor.getParameterNames(), descriptor.getParameters(), descriptor.getCoercer(), jsr223.getCompiled());
        }
        ExpressionScriptCompiledMVEL mvel = (ExpressionScriptCompiledMVEL)compiled;
        return new ScriptEvaluatorMVEL(descriptor.getScriptName(), descriptor.getParameterNames(), descriptor.getParameters(), descriptor.getCoercer(), mvel.getCompiled());
    }
}

