/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.core;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantAppliesEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantEnum;

public class BoundingBox {
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;

    public BoundingBox(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public boolean containsPoint(double x, double y) {
        return x >= this.minX && y >= this.minY && x < this.maxX && y < this.maxY;
    }

    public boolean intersectsBoxIncludingEnd(double x, double y, double width, double height) {
        return BoundingBox.intersectsBoxIncludingEnd(this.minX, this.minY, this.maxX, this.maxY, x, y, width, height);
    }

    public static boolean intersectsBoxIncludingEnd(double minX, double minY, double maxX, double maxY, double otherX, double otherY, double otherWidth, double otherHeight) {
        double otherMaxX = otherX + otherWidth;
        double otherMaxY = otherY + otherHeight;
        if (maxX < otherX) {
            return false;
        }
        if (minX > otherMaxX) {
            return false;
        }
        if (maxY < otherY) {
            return false;
        }
        return !(minY > otherMaxY);
    }

    public static boolean containsPoint(double x, double y, double width, double height, double px, double py) {
        if (px >= x + width) {
            return false;
        }
        if (px < x) {
            return false;
        }
        if (py >= y + height) {
            return false;
        }
        return !(py < y);
    }

    public String toString() {
        return "{minX=" + this.minX + ", minY=" + this.minY + ", maxX=" + this.maxX + ", maxY=" + this.maxY + "}";
    }

    public QuadrantEnum getQuadrant(double x, double y) {
        double deltaX = x - this.minX;
        double deltaY = y - this.minY;
        double halfWidth = (this.maxX - this.minX) / 2.0;
        double halfHeight = (this.maxY - this.minY) / 2.0;
        if (deltaX < halfWidth) {
            return deltaY < halfHeight ? QuadrantEnum.NW : QuadrantEnum.SW;
        }
        return deltaY < halfHeight ? QuadrantEnum.NE : QuadrantEnum.SE;
    }

    public QuadrantAppliesEnum getQuadrantApplies(double x, double y, double w, double h) {
        double deltaX = x - this.minX;
        double deltaY = y - this.minY;
        double halfWidth = (this.maxX - this.minX) / 2.0;
        double halfHeight = (this.maxY - this.minY) / 2.0;
        double midX = this.minX + halfWidth;
        double midY = this.minY + halfHeight;
        if (deltaX < halfWidth) {
            if (deltaY < halfHeight) {
                if (x + w < this.minX || y + h < this.minY) {
                    return QuadrantAppliesEnum.NONE;
                }
                if (x + w >= midX || y + h >= midY) {
                    return QuadrantAppliesEnum.SOME;
                }
                return QuadrantAppliesEnum.NW;
            }
            if (y > this.maxY || x + w < this.minX) {
                return QuadrantAppliesEnum.NONE;
            }
            if (x + w >= midX || y <= midY) {
                return QuadrantAppliesEnum.SOME;
            }
            return QuadrantAppliesEnum.SW;
        }
        if (deltaY < halfHeight) {
            if (x > this.maxX || y + h < this.minY) {
                return QuadrantAppliesEnum.NONE;
            }
            if (x <= midX || y + h >= midY) {
                return QuadrantAppliesEnum.SOME;
            }
            return QuadrantAppliesEnum.NE;
        }
        if (x > this.maxX || y > this.maxY) {
            return QuadrantAppliesEnum.NONE;
        }
        if (x <= midX || y <= midY) {
            return QuadrantAppliesEnum.SOME;
        }
        return QuadrantAppliesEnum.SE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        if (Double.compare(that.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(that.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(that.maxX, this.maxX) != 0) {
            return false;
        }
        return Double.compare(that.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minX);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public BoundingBox[] subdivide() {
        double w = (this.maxX - this.minX) / 2.0;
        double h = (this.maxY - this.minY) / 2.0;
        BoundingBox bbNW = new BoundingBox(this.minX, this.minY, this.minX + w, this.minY + h);
        BoundingBox bbNE = new BoundingBox(this.minX + w, this.minY, this.maxX, this.minY + h);
        BoundingBox bbSW = new BoundingBox(this.minX, this.minY + h, this.minX + w, this.maxY);
        BoundingBox bbSE = new BoundingBox(this.minX + w, this.minY + h, this.maxX, this.maxY);
        return new BoundingBox[]{bbNW, bbNE, bbSW, bbSE};
    }

    public BoundingBoxNode treeForDepth(int depth) {
        BoundingBoxNode[] quadrants = new BoundingBoxNode[4];
        if (depth > 0) {
            BoundingBox[] subs = this.subdivide();
            quadrants[0] = subs[0].treeForDepth(depth - 1);
            quadrants[1] = subs[1].treeForDepth(depth - 1);
            quadrants[2] = subs[2].treeForDepth(depth - 1);
            quadrants[3] = subs[3].treeForDepth(depth - 1);
        }
        return new BoundingBoxNode(this, quadrants[0], quadrants[1], quadrants[2], quadrants[3]);
    }

    public static BoundingBox from(double x, double y, double width, double height) {
        return new BoundingBox(x, y, x + width, y + height);
    }

    public BoundingBoxNode treeForPath(String[] path) {
        return this.treeForPath(path, 0);
    }

    private BoundingBoxNode treeForPath(String[] path, int offset) {
        BoundingBoxNode[] quadrants = new BoundingBoxNode[4];
        if (offset < path.length) {
            BoundingBox[] subs = this.subdivide();
            String q = path[offset];
            if (q.equals("nw")) {
                quadrants[0] = subs[0].treeForPath(path, offset + 1);
            }
            if (q.equals("ne")) {
                quadrants[1] = subs[1].treeForPath(path, offset + 1);
            }
            if (q.equals("sw")) {
                quadrants[2] = subs[2].treeForPath(path, offset + 1);
            }
            if (q.equals("se")) {
                quadrants[3] = subs[3].treeForPath(path, offset + 1);
            }
        }
        return new BoundingBoxNode(this, quadrants[0], quadrants[1], quadrants[2], quadrants[3]);
    }

    public static class BoundingBoxNode {
        public final BoundingBox bb;
        public final BoundingBoxNode nw;
        public final BoundingBoxNode ne;
        public final BoundingBoxNode sw;
        public final BoundingBoxNode se;

        public BoundingBoxNode(BoundingBox bb, BoundingBoxNode nw, BoundingBoxNode ne, BoundingBoxNode sw, BoundingBoxNode se) {
            this.bb = bb;
            this.nw = nw;
            this.ne = ne;
            this.sw = sw;
            this.se = se;
        }

        public BoundingBoxNode getQuadrant(QuadrantEnum q) {
            if (q == QuadrantEnum.NW) {
                return this.nw;
            }
            if (q == QuadrantEnum.NE) {
                return this.ne;
            }
            if (q == QuadrantEnum.SW) {
                return this.sw;
            }
            return this.se;
        }
    }
}

