/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.BoundingBox;
import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadTreeCollector;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.XYPointWValue;
import java.util.Collection;

public class PointRegionQuadTreeFilterIndexCollect {
    public static <L, T> void collectRange(PointRegionQuadTree<Object> quadTree, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector, ExprEvaluatorContext ctx) {
        PointRegionQuadTreeFilterIndexCollect.collectRange(quadTree.getRoot(), x, y, width, height, eventBean, target, collector, ctx);
    }

    private static <L, T> void collectRange(PointRegionQuadTreeNode<Object> node, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector, ExprEvaluatorContext ctx) {
        if (!node.getBb().intersectsBoxIncludingEnd(x, y, width, height)) {
            return;
        }
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            PointRegionQuadTreeFilterIndexCollect.collectLeaf(leaf, x, y, width, height, eventBean, target, collector, ctx);
            return;
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        PointRegionQuadTreeFilterIndexCollect.collectRange(branch.getNw(), x, y, width, height, eventBean, target, collector, ctx);
        PointRegionQuadTreeFilterIndexCollect.collectRange(branch.getNe(), x, y, width, height, eventBean, target, collector, ctx);
        PointRegionQuadTreeFilterIndexCollect.collectRange(branch.getSw(), x, y, width, height, eventBean, target, collector, ctx);
        PointRegionQuadTreeFilterIndexCollect.collectRange(branch.getSe(), x, y, width, height, eventBean, target, collector, ctx);
    }

    private static <L, T> void collectLeaf(PointRegionQuadTreeNodeLeaf node, double x, double y, double width, double height, EventBean eventBean, T target, QuadTreeCollector<L, T> collector, ExprEvaluatorContext ctx) {
        Object points = node.getPoints();
        if (points == null) {
            return;
        }
        if (points instanceof XYPointWValue) {
            XYPointWValue point = (XYPointWValue)points;
            if (BoundingBox.containsPoint(x, y, width, height, point.getX(), point.getY())) {
                collector.collectInto(eventBean, point.getValue(), target, ctx);
            }
            return;
        }
        Collection collection = (Collection)points;
        for (XYPointWValue point : collection) {
            if (!BoundingBox.containsPoint(x, y, width, height, point.getX(), point.getY())) continue;
            collector.collectInto(eventBean, point.getValue(), target, ctx);
        }
    }
}

