/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex;

import com.espertech.esper.common.internal.epl.spatial.quadtree.core.QuadrantEnum;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTree;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNode;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeBranch;
import com.espertech.esper.common.internal.epl.spatial.quadtree.pointregion.PointRegionQuadTreeNodeLeaf;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.PointRegionQuadTreeFilterIndexCheckBB;
import com.espertech.esper.common.internal.epl.spatial.quadtree.prqdfilterindex.XYPointWValue;
import java.util.Collection;

public class PointRegionQuadTreeFilterIndexGet {
    public static <L> L get(double x, double y, PointRegionQuadTree<Object> tree) {
        PointRegionQuadTreeFilterIndexCheckBB.checkBB(tree.getRoot().getBb(), x, y);
        return PointRegionQuadTreeFilterIndexGet.get(x, y, tree.getRoot());
    }

    private static <L> L get(double x, double y, PointRegionQuadTreeNode<Object> node) {
        if (node instanceof PointRegionQuadTreeNodeLeaf) {
            PointRegionQuadTreeNodeLeaf leaf = (PointRegionQuadTreeNodeLeaf)node;
            if (leaf.getPoints() == null) {
                return null;
            }
            if (leaf.getPoints() instanceof XYPointWValue) {
                XYPointWValue value = (XYPointWValue)leaf.getPoints();
                if (value.getX() == x && value.getY() == y) {
                    return value.getValue();
                }
                return null;
            }
            Collection collection = (Collection)leaf.getPoints();
            for (XYPointWValue point : collection) {
                if (point.getX() != x || point.getY() != y) continue;
                return point.getValue();
            }
            return null;
        }
        PointRegionQuadTreeNodeBranch branch = (PointRegionQuadTreeNodeBranch)node;
        QuadrantEnum q = node.getBb().getQuadrant(x, y);
        if (q == QuadrantEnum.NW) {
            return PointRegionQuadTreeFilterIndexGet.get(x, y, branch.getNw());
        }
        if (q == QuadrantEnum.NE) {
            return PointRegionQuadTreeFilterIndexGet.get(x, y, branch.getNe());
        }
        if (q == QuadrantEnum.SW) {
            return PointRegionQuadTreeFilterIndexGet.get(x, y, branch.getSw());
        }
        return PointRegionQuadTreeFilterIndexGet.get(x, y, branch.getSe());
    }
}

