/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.table.core;

import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.core.Table;
import java.util.HashMap;
import java.util.Map;

public class TableDeployment {
    private final Map<String, Table> tables = new HashMap<String, Table>(4);

    public void add(String tableName, TableMetaData metadata, EPStatementInitServices services) {
        Table existing = this.tables.get(tableName);
        if (existing != null) {
            throw new IllegalStateException("Table already found for name '" + tableName + "'");
        }
        Table table = services.getTableManagementService().allocateTable(metadata);
        this.tables.put(tableName, table);
    }

    public Table getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public void remove(String tableName) {
        this.tables.remove(tableName);
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public Map<String, Table> getTables() {
        return this.tables;
    }
}

